% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data_cube.r
\name{download_abs_data_cube}
\alias{download_abs_data_cube}
\title{Experimental helper function to download ABS data cubes that are not compatible with read_abs.}
\usage{
download_abs_data_cube(
  cat_no,
  cube,
  path = Sys.getenv("R_READABS_PATH", unset = tempdir()),
  latest = TRUE,
  date = NULL
)
}
\arguments{
\item{cat_no}{ABS catalogue number, as a string, including the extension.
For example, Labour Force, Australia, Detailed, Quarterly is "6291.0.55.003".}

\item{cube}{character. A character string that is in the filename of the data cube you want to
download, e.g. "EQ09".}

\item{path}{Local directory in which downloaded files should be stored. By default, `path`
takes the value set in the #' environment variable "R_READABS_PATH".
If this variable is not set, #' any files downloaded by read_abs()
will be stored in a temporary directory #' (\code{tempdir()}).
See \code{Details} below for #' more information.}

\item{latest}{logical. If `TRUE` (the default), the function tries to find the latest release.}

\item{date}{character. If `latest` is set to `FALSE` the function will attempt to download the
files on the page specified by that date.
The format of the date should match the format on the human readable ABS website,
e.g. "Feb 2020" for Catalogue Number 6291.0.55.003.}
}
\description{
\code{download_abs_data_cube()} downloads ABS data cubes based on the catalogue number and cube.
The function downloads the file to disk.
In comparison to \code{read_abs()} this function doesn't tidy the data.
}
\details{
`download_abs_data_cube()` downloads a file from the ABS containing a data cube.
These files need to be saved somewhere on your disk.
This local directory can be controlled using the `path` argument to
`read_abs()`. If the `path` argument is not set, `read_abs()` will store
the files in a directory set in the "R_READABS_PATH" environment variable.
If this variable isn't set, files will be saved in a temporary directory.

To check the value of the "R_READABS_PATH" variable, run
\code{Sys.getenv("R_READABS_PATH")}. You can set the value of this variable
for a single session using \code{Sys.setenv(R_READABS_PATH = <path>)}.
If you would like to change this variable for all future R sessions, edit
your `.Renviron` file and add \code{R_READABS_PATH = <path>} line.
The easiest way to edit this file is using \code{usethis::edit_r_environ()}.

The filepath is returned invisibly which enables piping to \code{unzip()} or \code{reaxl::read_excel}.
}
\examples{

\dontrun{download_abs_data_cube(cat_no = "6291.0.55.003",
                                        cube = "EQ09")}

}
