% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_ods_sheets.R
\name{list_ods_sheets}
\alias{list_ods_sheets}
\alias{list_fods_sheets}
\alias{ods_sheets}
\title{Get information in an (F)ODS File}
\usage{
list_ods_sheets(path, include_external_data = FALSE)

list_fods_sheets(path, include_external_data = FALSE)

ods_sheets(path)
}
\arguments{
\item{path}{Path to the (f)ods file}

\item{include_external_data}{A boolean value to show or hide sheets containing archived linked data (default false)}
}
\value{
A character vector of sheet names
}
\description{
\verb{list_(f)ods_sheets} lists all sheets in an (f)ods file.
}
\details{
The default "include_external_data" for \code{ods_sheets} is TRUE to maintain compatibility with version 1 of readODS. It will change to \code{TRUE} in version 3.
}
\examples{
\dontrun{
# Get the list of names of sheets
list_ods_sheets("starwars.ods")
list_fods_sheets("starwars.fods")
}
}
\seealso{
use \code{\link{read_ods}} to read the data
}
\author{
Peter Brohan \href{mailto:peter.brohan+cran@gmail.com}{peter.brohan+cran@gmail.com}, Chung-hong Chan \href{mailto:chainsawtiney@gmail.com}{chainsawtiney@gmail.com}, Gerrit-Jan Schutten \href{mailto:phonixor@gmail.com}{phonixor@gmail.com}
}
