% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reReg.R
\name{reReg}
\alias{reReg}
\title{Fits Semiparametric Regression Models for Recurrent Event Data}
\usage{
reReg(
  formula,
  data,
  B = 200,
  method = "cox",
  se = c("resampling", "bootstrap", "NULL"),
  control = list()
)
}
\arguments{
\item{formula}{a formula object, with the response on the left of a "~" operator, and the predictors on the right.
The response must be a recurrent event survival object as returned by function \code{Recur}.}

\item{data}{an optional data frame in which to interpret the variables occurring in the \code{"formula"}.}

\item{B}{a numeric value specifies the number of resampling for variance estimation.
When \code{B = 0}, variance estimation will not be performed.}

\item{method}{a character string specifying the underlying model. See \bold{Details}.}

\item{se}{a character string specifying the method for standard error estimation. See \bold{Details}.}

\item{control}{a list of control parameters.}
}
\description{
Fits a general (joint) semiparametric regression model for the recurrent event data,
where the rate function of the underlying recurrent event process and
the hazard function of the terminal event can be specified as a Cox-type model,
an accelerated mean model, an accelerated rate model, or a generalized scale-change model.
See details for model specifications.
}
\details{
Suppose the recurrent event process and the failure events are
observed in the time interval \eqn{t\in[0,\tau]},
for some constant \eqn{\tau}.
We formulate the recurrent event rate function, \eqn{\lambda(t)},
and the terminal event hazard function, \eqn{h(t)}, 
in the form of
\deqn{\lambda(t) = Z \lambda_0(te^{X^\top\alpha}) e^{X^\top\beta}, h(t) = Z h_0(te^{X^\top\eta})e^{X^\top\theta},}
where \eqn{\lambda_0(t)} is the baseline rate function,
\eqn{h_0(t)} is the baseline hazard function,
\eqn{X} is a \eqn{n} by \eqn{p} covariate matrix and \eqn{\alpha},
\eqn{Z} is an unobserved shared frailty variable, and
\eqn{(\alpha, \eta)} and \eqn{(\beta, \theta)} correspond to the shape and size parameters of the
rate function and the hazard function, respectively.
The model includes several popular semiparametric models as special cases,
which can be specified via the \code{method} argument with the rate function
and hazard function separated by "\code{|}".
For examples,
Wang, Qin and Chiang (2001) (\eqn{\alpha = \eta = \theta = 0})
can be called with \code{method = "cox|."};
Huang and Wang (2004) (\eqn{\alpha = \eta = 0})
can be called with \code{method = "cox|cox"};
Xu et al. (2017) (\eqn{\alpha = \beta} and \eqn{\eta = \theta})
can be called with \code{method = "am|am"};
Xu et al. (2019) (\eqn{\eta = \theta = 0}) can be called with \code{method = "sc|."}.
Users can mix the models depending on the application. For example,
\code{method = "cox|ar"} postulate a Cox proportional model for the
recurrent event rate function and an accelerated rate model for
the terminal event hazard function (\eqn{\alpha = \theta = 0}).
If only one method is specified without an "\code{|}",
it is used for both the rate function and the hazard function.
For example, specifying \code{method = "cox"} is equivalent to \code{method = "cox|cox"}.
Some methods that assumes \code{Z = 1} and requires independent
censoring are also implemented in \code{reReg};
these includes \code{method = "cox.LWYY"} for Lin et al. (2000),
\code{method = "cox.GL"} for Ghosh and Lin (2002),
and \code{method = "am.GL"} for Ghosh and Lin (2003).

The available methods for variance estimation are:
\describe{
  \item{NULL}{variance estimation will not be performed. This is equivalent to setting \code{B = 0}.}
  \item{resampling}{performs the efficient resampling-based variance estimation.}
  \item{bootstrap}{performs nonparametric bootstrap.}
}

The \code{control} list consists of the following parameters:
\describe{
  \item{tol}{absolute error tolerance.}
  \item{a0, b0}{initial guesses used for root search.}
  \item{solver}{the equation solver used for root search. The available options are \code{BB::BBsolve}, \code{BB::dfsane}, \code{BB:BBoptim}, and \code{optim}.}
  \item{baseSE}{an logical value indicating whether the 95\% confidence bounds for the baseline functions will be computed.}
  \item{parallel}{an logical value indicating whether parallel computation will be applied when \code{se = "bootstrap"} is called.}
  \item{parCl}{an integer value specifying the number of CPU cores to be used when \code{parallel = TRUE}. The default value is half the CPU cores on the current host.}
}
}
\examples{
fm <- Recur(Time, id, event, status) ~ x1 + x2

## Joint Cox/Accelerated Mean Model
set.seed(1)
dat <- simSC(50, c(-1, 1), c(-1, 1), type = "cox|am")
(fit <- reReg(Recur(Time, id, event, status) ~ x1 + x2, 
              data = dat, method = "cox|am", B = 50))
summary(fit)

## Generalized Scale-Change Model
set.seed(1)
dat <- simSC(50, c(-1, 1), c(-1, 1), type = "sc")
(fit <- reReg(Recur(Time, id, event, status) ~ x1 + x2, 
              data = dat, method = "sc|.", B = 50))
summary(fit)
}
\references{
Lin, D., Wei, L., Yang, I. and Ying, Z. (2000). Semiparametric Regression for the Mean and Rate Functions of Recurrent Events.
\emph{Journal of the Royal Statistical Society: Series B (Methodological)}, \bold{62}: 711--730.

Wang, M.-C., Qin, J., and Chiang, C.-T. (2001). Analyzing Recurrent Event Data with Informative Censoring.
\emph{Journal of the American Statistical Association}, \bold{96}(455): 1057--1065.

Ghosh, D. and Lin, D.Y. (2002). Marginal Regression Models for Recurrent and Terminal Events. \emph{Statistica Sinica}: 663--688.

Ghosh, D. and Lin, D.Y. (2003). Semiparametric Analysis of Recurrent Events Data in the Presence of Dependent Censoring.
\emph{Biometrics}, \bold{59}: 877--885.

Huang, C.-Y. and Wang, M.-C. (2004). Joint Modeling and Estimation for Recurrent Event Processes and Failure Time Data.
\emph{Journal of the American Statistical Association}, \bold{99}(468): 1153--1165.

Xu, G., Chiou, S.H., Huang, C.-Y., Wang, M.-C. and Yan, J. (2017). Joint Scale-change Models for Recurrent Events and Failure Time.
\emph{Journal of the American Statistical Association}, \bold{112}(518): 796--805.

Xu, G., Chiou, S.H.,Yan, J., Marr, K., and Huang, C.-Y. (2019). Generalized Scale-Change Models for Recurrent Event
Processes under Informative Censoring. \emph{Statistica Sinica}: pre-print.
}
\seealso{
\code{\link{Recur}}, \code{\link{simSC}}
}
