% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readDWD.R
\name{projectRasterDWD}
\alias{projectRasterDWD}
\title{project DWD raster data}
\usage{
projectRasterDWD(r, proj = "radolan", extent = "radolan",
  latlon = TRUE)
}
\arguments{
\item{r}{Raster object}

\item{proj}{Desired projection. Can be a \code{raster::\link[raster]{crs}} output,
a projection character string (will be passed to \code{crs}), 
"radolan" or "seasonal" with internal defaults defined per DWD standard, 
or NULL to not set proj+extent but still consider \code{latlon}.
DEFAULT: "radolan"}

\item{extent}{Desired \code{\link[raster]{extent}}. Can be an extent object,
a vector with 4 numbers, or "radolan" / "rw" / "seasonal" 
with internal defaults.
DEFAULT: "radolan"}

\item{latlon}{Logical: reproject \code{r} to lat-lon crs? DEFAULT: TRUE}
}
\value{
Raster object with projection and extent, invisible
}
\description{
Set projection and extent for DWD raster data. Optionally (and
per default) also reprojects to latlon data.
The internal defaults are extracted from the
Kompositformatbeschreibung at \url{https://www.dwd.de/DE/leistungen/radolan/radolan.html},
as provided 2019-04 by Antonia Hengst.
}
\examples{
# To be used after readDWD.binary, readDWD.raster, readDWD.asc
}
\seealso{
\code{raster::\link[raster]{crs}}, 
         \code{raster::\link[raster]{projection}},
         \code{raster::\link[raster]{extent}},
         \code{raster::\link[raster]{projectRaster}},
         \code{\link{readDWD.binary}, \link{readDWD.raster}, \link{readDWD.asc}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, May 2019
}
\keyword{aplot}
