% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gets.R
\name{dnb_search}
\alias{dnb_search}
\title{Search the DNB catalogue - simple search}
\source{
\url{http://www.dnb.de/EN/Service/DigitaleDienste/SRU/sru_node.html}
}
\usage{
dnb_search(title, author, year, publisher, keyword, type, language,
  limit = 10, clean = TRUE, print = FALSE)
}
\arguments{
\item{title}{the title (including subtitle, short title, volume title, etc.); optional single string value or vector of strings.}

\item{author}{the author(s); optional single string value or vector of strings.}

\item{year}{the year of publishing; optional single integer value or vector of integers.}

\item{publisher}{the publisher (publisher name and/or location); optional single string value or vector of strings.}

\item{keyword}{one or a set of keywords describing the work (subjects, persons, locations, organisations, etc.); optional single string value or vector of strings.}

\item{type}{the type of publication (optional), one or a vector of \code{articles}, \code{manuscript}, \code{biographicaldoc}, \code{letters}, \code{bequest}, \code{collections}, \code{books}, \code{brailles}, \code{maps}, \code{discs}, \code{dissertations}, \code{online}, \code{films}, \code{microfiches}, \code{multimedia}, \code{music}, \code{scores}, \code{serials}, \code{persons}, \code{subjects}, \code{corperations}, \code{works}, \code{events}, \code{geographics}.}

\item{language}{the language of the work by ISO 639-2/B code (\url{http://www.dnb.de/SharedDocs/Downloads/DE/DNB/standardisierung/inhaltserschliessung/sprachenCodesEnglisch.pdf?__blob=publicationFile}); single string value or vector of strings.}

\item{limit}{number and (optional) starting point of results returned; single integer value (number of results), vector of two integer values (number of results and first result, >=1) or \code{"all"} for a complete list of results.}

\item{clean}{if \code{TRUE} (the default), the results are cleaned (see \code{\link{dnb_advanced}} for details).}

\item{print}{if \code{TRUE} the search results are printed (default is \code{FALSE}).}
}
\value{
A list of results with metadata.
}
\description{
\code{dnb_search} exposes a search in the DNB catalogue.
}
\details{
to do
}
\examples{
\dontrun{
# title search
single.title <- dnb_search(title="katze")
multi.title <- dnb_search(title=c("katze", "kater", "+maus", "-hund"))

# author search
single.author <- dnb_search(author="kern")
author.or.author <- dnb_search(author=c("kern", "locke"))
author.and.author <- dnb_search(author=c("kern", "+locke"))
author.not.author <- dnb_search(author=c("kern", "-locke"))

# publication year 
single.year <- dnb_search(title="katze", year=2015)
sequence.of.years <- dnb_search(title="katze", year=2010:2015)
set.of.years <- dnb_search(title="katze", year=c(2010:2013, 2015))

# publisher search
single.publisher <- dnb_search(title="katze", publisher="kiepenheuer")
set.of.publishers <- dnb_search(title="katze", publisher=c("kiepenheuer", "piper"))

# keyword search
single.keyword <- dnb_search(author="kern")
keyword.or.keyword <- dnb_search(keyword=c("katze", "hund"))
keyword.and.keyword <- dnb_search(keyword=c("katze", "+hund"))
keyword.not.keyword <- dnb_search(keyword=c("katze", "-hund"))

# type search
single.type <- dnb_search(title="katze", type="books")
set.of.types <- dnb_search(title="katze", type=c("books", "articles", "online"))

# language search
single.language <- dnb_search(title="cat", language="eng")
set.of.languages <- dnb_search(title=c("cat", "katze"), language=c("eng", "ger"))

# change limit of results
first.result <- dnb_search(title="katze", limit=1)
5.results.starting.with.the.21st <- dnb_search(title="katze", limit=c(5, 21))
all.results <- dnb_search(title="katze", limit="all")
}
}
