% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DaiAuthenticationKeyService.R
\name{dfp_getDaiAuthenticationKeysByStatement}
\alias{dfp_getDaiAuthenticationKeysByStatement}
\title{getDaiAuthenticationKeysByStatement}
\usage{
dfp_getDaiAuthenticationKeysByStatement(request_data, as_df = TRUE,
  verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a getDaiAuthenticationKeysByStatementResponse
}
\description{
Gets a DaiAuthenticationKeyPage of DaiAuthenticationKey objects that satisfy the given Statement query. The following fields are supported for filtering: 
\itemize{
  \item{id}
  \item{status}
  \item{name}
}
}
\examples{
\dontrun{
 dat <- list(filterStatement=list('query'="WHERE status='ACTIVE'")) 
 res <- dfp_getDaiAuthenticationKeysByStatement(dat)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201905/DaiAuthenticationKeyService#getDaiAuthenticationKeysByStatement}{Google Documentation for getDaiAuthenticationKeysByStatement}
}
