% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdf.R
\docType{package}
\name{rdflib-package}
\alias{rdflib}
\alias{rdflib-package}
\title{rdflib: Tools to Manipulate and Query Semantic Data}
\description{
The Resource Description Framework, or RDF is a widely used
data representation model that forms the cornerstone of the
Semantic Web. 'RDF' represents data as a graph rather than
the familiar data table or rectangle of relational databases.
}
\details{
It has three main goals:

\itemize{
\item Easily read, write, and convert between all major RDF serialization formats
\item Support SPARQL queries to extract data from an RDF graph into a data.frame
\item Support JSON-LD format as a first-class citizen in RDF manipulations
}

For more information, see the Wikipedia pages for RDF, SPARQL, and JSON-LD:

\itemize{
\item \url{https://en.wikipedia.org/wiki/Resource_Description_Framework}
\item \url{https://en.wikipedia.org/wiki/SPARQL}
\item \url{https://en.wikipedia.org/wiki/JSON-LD}
}

To learn more about rdflib, start with the vignettes:
\code{browseVignettes(package = "rdflib")}

Configurations via \code{options()}

\code{rdflib_print_format}:
\itemize{
\item NULL or "nquads" (default)
\item any valid serializer name: e.g. "rdfxml", "jsonld", "turtle",  "ntriples"
}

\code{rdflib_base_uri}:
\itemize{
\item Default base URI to use (when serializing JSON-LD only at this time)
default is "localhost://"
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/ropensci/rdflib}
  \item Report bugs at \url{https://github.com/ropensci/rdflib/issues}
}

}
\author{
\strong{Maintainer}: Carl Boettiger \email{cboettig@gmail.com} (0000-0002-1642-628X) [copyright holder]

}
