% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stdyInfo.R
\name{ddi_subject}
\alias{ddi_subject}
\alias{ddi_keyword}
\alias{ddi_topcClas}
\title{subject and its child nodes}
\usage{
ddi_subject(...)

ddi_keyword(...)

ddi_topcClas(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
Subject describes the data collection's intellectual content. More
information on these elements, especially their allowed attributes, can be
found in the references.
}
\details{
\emph{Parent nodes}

\code{subject} is contained in \code{stdyInfo}.

\emph{subject specific child nodes}
\itemize{
\item \code{ddi_keyword()} are words or phrases that describe salient aspects of a
data collection's content. Can be used for building keyword indexes and for
classification and retrieval purposes. A controlled vocabulary can be
employed. Maps to Dublin Core Subject element.
\item \code{ddi_topcClas()} indicates the broad substantive topic(s) that the data
cover. Library of Congress subject terms may be used here. Maps to Dublin
Core Subject element. Inclusion of this element in the codebook is
recommended.
}
}
\examples{
ddi_subject()

# Functions that need to be wrapped in ddi_subject()

ddi_keyword(vocab = "ICPSR Subject Thesaurus",
            vocabURI = "http://www.icpsr.umich.edu/thesaurus/subject.html",
            "quality of life")

ddi_topcClas(vocab = "LOC Subject Headings",
             vocabURI = "http://www.loc.gov/catdir/cpso/lcco/lcco.html",
             "Public opinion -- California -- Statistics")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/subject.html}{subject documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/keyword.html}{keyword documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/topcClas.html}{topcClas documentation}
}
