% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/studyDevelopment.R
\name{ddi_developmentActivity}
\alias{ddi_developmentActivity}
\alias{ddi_description}
\alias{ddi_outcome}
\alias{ddi_participant}
\title{developmentActivity and its child nodes}
\usage{
ddi_developmentActivity(...)

ddi_description(...)

ddi_outcome(...)

ddi_participant(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
Describe the activity, listing participants with their role and affiliation,
resources used (sources of information), and the outcome of the development
activity.
}
\details{
\emph{Parent nodes}

\code{developmentActivity} is contained in \code{studyDevelopment}.

\emph{developmentActivity specific child nodes}
\itemize{
\item \code{ddi_description()} describes the development activity.
\item \code{ddi_outcome()} describes the outcome of the development activity.
\item \code{ddi_participant()} lists teh participants conducting or designing the
development activity.
}
}
\section{Shared and complex child nodes}{

\itemize{
\item \code{\link[=ddi_resource]{ddi_resource()}}
}
}

\examples{
ddi_developmentActivity(type = "checkDataAvailability")

# Functions that need to be wrapped in ddi_developmentActivity()

ddi_description("A number of potential sources were evaluated for content, 
                consistency and quality")

ddi_outcome("Due to quality issues this was determined not to be a viable 
            source of data for the study")

ddi_participant(affiliation = "NSO",
                role = "statistician",
                "John Doe")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/developmentActivity.html}{developmentActivity documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/description.html}{description documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/outcome.html}{outcome documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/participant.html}{participant documentation}
}
