% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdataretriever.R
\name{install_postgres}
\alias{install_postgres}
\title{Install datasets via the Data Retriever.}
\usage{
install_postgres(dataset, user = "postgres", password = "",
  host = "localhost", port = 5432, database = "postgres",
  database_name = "{db}", table_name = "{db}.{table}", bbox = list(),
  debug = FALSE, use_cache = TRUE)
}
\arguments{
\item{dataset}{the name of the dataset that you wish to install}

\item{user}{username for database connection}

\item{password}{password for database connection}

\item{host}{hostname for connection}

\item{port}{port number for connection}

\item{database}{the database name default is postres}

\item{database_name}{database schema name in which dataset will be installed}

\item{table_name}{table name specified especially for datasets
containing one file}

\item{bbox}{Optional extent values used to fetch data from the spatial dataset}

\item{debug}{Setting TRUE helps in debugging in case of errors}

\item{use_cache}{Setting FALSE reinstalls scripts even if they are already installed}
}
\description{
Data is stored in PostgreSQL database
}
\examples{
\donttest{
rdataretriever::install_postgres(dataset='portal', user='postgres', password='abcdef')
}
}
