% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cr_members.r
\name{cr_members}
\alias{cr_members}
\alias{cr_members_}
\title{Search CrossRef members}
\usage{
cr_members(member_ids = NULL, query = NULL, filter = NULL,
  offset = NULL, limit = NULL, sample = NULL, sort = NULL,
  order = NULL, facet = FALSE, works = FALSE, cursor = NULL,
  cursor_max = 5000, .progress = "none", ...)

cr_members_(member_ids = NULL, query = NULL, filter = NULL,
  offset = NULL, limit = NULL, sample = NULL, sort = NULL,
  order = NULL, facet = FALSE, works = FALSE, cursor = NULL,
  cursor_max = 5000, .progress = "none", parse = FALSE, ...)
}
\arguments{
\item{member_ids}{One or more member ids. See examples. ALternatively, you can query for them
using the query parameter.}

\item{query}{Query terms}

\item{filter}{Filter options. See details.}

\item{offset}{Number of record to start at, from 1 to infinity.}

\item{limit}{Number of results to return in the query. Not relavant when searching with specific
dois. Default: 20. Max: 1000}

\item{sample}{(integer) Number of random results to return. when you use the sample parameter, 
the rows and offset parameters are ignored. Ignored unless \code{works=TRUE}}

\item{sort}{(character) Field to sort on, one of score, relevance, updated, deposited, indexed, 
or published.}

\item{order}{(character) Sort order, one of 'asc' or 'desc'}

\item{facet}{(logical) Include facet results. Default: \code{FALSE}}

\item{works}{(logical) If TRUE, works returned as well, if not then not.}

\item{cursor}{(character) Cursor character string to do deep paging. Default is None.
Pass in '*' to start deep paging. Any combination of query, filters and facets may be
used with deep paging cursors. While rows may be specified along with cursor, offset
and sample cannot be used.
See https://github.com/CrossRef/rest-api-doc/blob/master/rest_api.md#deep-paging-with-cursors}

\item{cursor_max}{(integer) Max records to retrieve. Only used when cursor param used. 
Because deep paging can result in continuous requests until all are retrieved, use this
parameter to set a maximum number of records. Of course, if there are less records
found than this value, you will get only those found.}

\item{.progress}{Show a \code{plyr}-style progress bar? Options are "none", "text", 
"tk", "win", and "time".  See \code{\link[plyr]{create_progress_bar}} for details 
of each. Only used when passing in multiple ids (e.g., multiple DOIs, DOI prefixes,
etc.)}

\item{...}{Named parameters passed on to \code{\link[httr]{GET}}}

\item{parse}{(logical) Whether to output json \code{FALSE} or parse to
list \code{TRUE}. Default: \code{FALSE}}
}
\description{
Search CrossRef members
}
\details{
BEWARE: The API will only work for CrossRef DOIs.
}
\examples{
\dontrun{
cr_members(member_ids=98)
cr_members(member_ids=340)

cr_members(member_ids=98, works=TRUE)
cr_members(member_ids=c(10,98,45,1,9))
cr_members(member_ids=c(10,98,45,1,9), works=TRUE)

cr_members(query='hindawi')
cr_members(query='ecology')

# facets
cr_members(member_ids=98, works=TRUE, facet=TRUE)

# curl options
library('httr')
cr_members(member_ids=98, config=verbose())

# Use the cursor for deep paging
cr_members(member_ids=98, works = TRUE, cursor = "*", cursor_max = 500, limit = 100)
cr_members(member_ids=c(10, 98, 45), works = TRUE, cursor = "*", cursor_max = 200, limit = 100)

# data not found
# cr_members(query="adfdf")
# cr_members(member_ids=c(323234343434,3434343434), works=TRUE, facet=TRUE)
# cr_members(member_ids=c(323234343434,3434343434,98), works=TRUE, facet=TRUE)

# Low level function - does no parsing to data.frame, get json or a list
cr_members_(query = 'hindawi')
cr_members_(member_ids = 98)
cr_members_(query = 'hindawi', parse=TRUE)
cr_members_(member_ids = 98, works = TRUE, cursor = "*",
   cursor_max = 300, limit = 100)
cr_members_(member_ids = 98, works = TRUE, cursor = "*",
   cursor_max = 300, limit = 100, parse=TRUE)
}
}
\references{
\url{https://github.com/CrossRef/rest-api-doc/blob/master/rest_api.md}
}

