% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exampledata.R
\name{get_dem_example_data}
\alias{get_dem_example_data}
\title{Get example DEM data}
\usage{
get_dem_example_data(force_download = FALSE)
}
\arguments{
\item{force_download}{Download data even if cached data is available}
}
\value{
An object of class \code{\link[terra:SpatRaster-class]{terra::SpatRaster}} containing the DEM data.
}
\description{
This function retrieves example Digital Elevation Model (DEM) data from the
Zenodo data repository, and it can be used in examples and tests. The code
used to generate the example dataset is available at
https://github.com/CityRiverSpaces/CRiSpExampleData. Note that the example
dataset is cached locally, so that subsequent calls to the function can
load the example data from disk without having to re-download the data.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
get_dem_example_data(force_download = TRUE)
\dontshow{\}) # examplesIf}
}
