% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_repostatus_badge.R
\name{add_repostatus_badge}
\alias{add_repostatus_badge}
\title{Add a Repository status badge}
\usage{
add_repostatus_badge(status = "concept", quiet = FALSE)
}
\arguments{
\item{status}{a character of length 1

Accepted status are: \code{'concept'} (default), \code{'wip'}, \code{'suspended'},
\code{'abandoned'}, \code{'active'}, \code{'inactive'}, or \code{'unsupported'}.}

\item{quiet}{a logical value

If \code{TRUE} messages are deleted. Default is \code{FALSE}.}
}
\value{
A Markdown badge expression
}
\description{
This function adds or updates the Repo Status badge of the project to the
\code{README.Rmd}. It is based on the standard defined by the
\url{https://www.repostatus.org} project.
}
\details{
The project can have the following status:
\itemize{
\item \strong{Concept} - Minimal or no implementation has been done yet, or the
repository is only intended to be a limited example, demo, or
proof-of-concept.
\item \strong{WIP} - Initial development is in progress, but there has not yet
been a stable, usable release suitable for the public.
\item \strong{Suspended} - Initial development has started, but there has not
yet been a stable, usable release; work has been stopped for the time
being but the author(s) intend on resuming work.
\item \strong{Abandoned} - Initial development has started, but there has not
yet been a stable, usable release; the project has been abandoned and the
author(s) do not intend on continuing development.
\item \strong{Active} - The project has reached a stable, usable state and is
being actively developed.
\item \strong{Inactive} - The project has reached a stable, usable state but is
no longer being actively developed; support/maintenance will be provided
as time allows.
\item \strong{Unsupported} - The project has reached a stable, usable state but
the author(s) have ceased all work on it. A new maintainer may be desired.
}
}
\examples{
\dontrun{
add_repostatus_badge()
add_repostatus_badge(status = "active")
}
}
\seealso{
Other adding badges: 
\code{\link{add_codecov_badge}()},
\code{\link{add_cran_badge}()},
\code{\link{add_dependencies_badge}()},
\code{\link{add_github_actions_check_badge}()},
\code{\link{add_github_actions_codecov_badge}()},
\code{\link{add_github_actions_pkgdown_badge}()},
\code{\link{add_license_badge}()},
\code{\link{add_lifecycle_badge}()}
}
\concept{adding badges}
