/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.tools.manipulator.MolecularFormulaManipulator;

public class IsotopeContainer {
    private List<IMolecularFormula> forms = new ArrayList<IMolecularFormula>();
    private double masOs;
    private double inte;

    public IsotopeContainer() {
    }

    public IsotopeContainer(IMolecularFormula formula, double intensity) {
        this.forms.add(formula);
        if (formula != null) {
            this.masOs = MolecularFormulaManipulator.getTotalExactMass(formula);
        }
        this.inte = intensity;
    }

    public IsotopeContainer(double mass, double intensity) {
        this.masOs = mass;
        this.inte = intensity;
    }

    public IsotopeContainer(IsotopeContainer container) {
        this.masOs = container.masOs;
        this.inte = container.inte;
        this.forms = new ArrayList<IMolecularFormula>(container.forms);
    }

    public void setFormula(IMolecularFormula formula) {
        this.forms.clear();
        this.forms.add(formula);
    }

    public void addFormula(IMolecularFormula formula) {
        this.forms.add(formula);
    }

    public void setMass(double mass) {
        this.masOs = mass;
    }

    public void setIntensity(double intensity) {
        this.inte = intensity;
    }

    public IMolecularFormula getFormula() {
        return this.forms.isEmpty() ? null : this.forms.get(0);
    }

    public List<IMolecularFormula> getFormulas() {
        return Collections.unmodifiableList(this.forms);
    }

    public double getMass() {
        return this.masOs;
    }

    public double getIntensity() {
        return this.inte;
    }

    public Object clone() throws CloneNotSupportedException {
        IsotopeContainer isoClone = new IsotopeContainer();
        isoClone.forms.addAll(this.getFormulas());
        isoClone.setIntensity(this.getIntensity());
        isoClone.setMass(this.getMass());
        return isoClone;
    }

    String getFormulasString() {
        StringBuilder sb = new StringBuilder();
        for (IMolecularFormula mf : this.getFormulas()) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(MolecularFormulaManipulator.getString(mf, false, true));
        }
        return sb.toString();
    }

    public String toString() {
        return "IsotopeContainer{mass=" + this.masOs + ", intensity=" + this.inte + ", MF=" + this.getFormulasString() + '}';
    }
}

