/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.diff;

import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.tools.diff.AtomDiff;
import org.openscience.cdk.tools.diff.ElectronContainerDiff;
import org.openscience.cdk.tools.diff.tree.BondOrderDifference;
import org.openscience.cdk.tools.diff.tree.ChemObjectDifference;
import org.openscience.cdk.tools.diff.tree.IDifference;
import org.openscience.cdk.tools.diff.tree.IntegerDifference;

public class BondDiff {
    private BondDiff() {
    }

    public static String diff(IChemObject first, IChemObject second) {
        IDifference diff = BondDiff.difference(first, second);
        if (diff == null) {
            return "";
        }
        return diff.toString();
    }

    public static IDifference difference(IChemObject first, IChemObject second) {
        if (!(first instanceof IBond) || !(second instanceof IBond)) {
            return null;
        }
        IBond firstB = (IBond)first;
        IBond secondB = (IBond)second;
        ChemObjectDifference totalDiff = new ChemObjectDifference("BondDiff");
        totalDiff.addChild(BondOrderDifference.construct("order", firstB.getOrder(), secondB.getOrder()));
        totalDiff.addChild(IntegerDifference.construct("atomCount", firstB.getAtomCount(), secondB.getAtomCount()));
        if (firstB.getAtomCount() == secondB.getAtomCount()) {
            totalDiff.addChild(AtomDiff.difference(firstB.getBegin(), secondB.getBegin()));
            totalDiff.addChild(AtomDiff.difference(firstB.getEnd(), secondB.getEnd()));
            for (int i = 2; i < firstB.getAtomCount(); ++i) {
                totalDiff.addChild(AtomDiff.difference(firstB.getAtom(i), secondB.getAtom(i)));
            }
        }
        totalDiff.addChild(ElectronContainerDiff.difference(first, second));
        if (totalDiff.childCount() > 0) {
            return totalDiff;
        }
        return null;
    }
}

