/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula;

import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.tools.manipulator.MolecularFormulaManipulator;

public class IsotopeContainer {
    private IMolecularFormula form;
    private double masOs;
    private double inte;

    public IsotopeContainer() {
    }

    public IsotopeContainer(IMolecularFormula formula, double intensity) {
        this.form = formula;
        if (formula != null) {
            this.masOs = MolecularFormulaManipulator.getTotalExactMass(formula);
        }
        this.inte = intensity;
    }

    public IsotopeContainer(double mass, double intensity) {
        this.masOs = mass;
        this.inte = intensity;
    }

    public void setFormula(IMolecularFormula formula) {
        this.form = formula;
    }

    public void setMass(double mass) {
        this.masOs = mass;
    }

    public void setIntensity(double intensity) {
        this.inte = intensity;
    }

    public IMolecularFormula getFormula() {
        return this.form;
    }

    public double getMass() {
        return this.masOs;
    }

    public double getIntensity() {
        return this.inte;
    }

    public Object clone() throws CloneNotSupportedException {
        IsotopeContainer isoClone = new IsotopeContainer();
        isoClone.setFormula(this.getFormula());
        isoClone.setIntensity(this.getIntensity());
        isoClone.setMass(this.getMass());
        return isoClone;
    }
}

