/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.config.isotopes.IsotopeReader;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IIsotope;

@TestClass(value="org.openscience.cdk.config.XMLIsotopeFactoryTest")
public class XMLIsotopeFactory
extends IsotopeFactory {
    private static XMLIsotopeFactory ifac = null;
    private boolean debug = false;

    private XMLIsotopeFactory(IChemObjectBuilder builder) throws IOException {
        InputStream ins;
        logger.info((Object)"Creating new IsotopeFactory");
        String errorMessage = "There was a problem getting org.openscience.cdk.config.isotopes.xml as a stream";
        try {
            String configFile = "org/openscience/cdk/config/data/isotopes.xml";
            if (this.debug) {
                logger.debug((Object)"Getting stream for ", new Object[]{configFile});
            }
            ins = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(configFile);
        }
        catch (Exception exception) {
            logger.error((Object)errorMessage);
            logger.debug((Object)exception);
            throw new IOException(errorMessage);
        }
        if (ins == null) {
            logger.error((Object)errorMessage);
            throw new IOException(errorMessage);
        }
        IsotopeReader reader = new IsotopeReader(ins, builder);
        this.isotopes = new HashMap();
        List<IIsotope> isotopes = reader.readIsotopes();
        for (IIsotope isotope : isotopes) {
            this.add(isotope);
        }
        if (this.debug) {
            logger.debug((Object)"Found #isotopes in file: ", new Object[]{isotopes.size()});
        }
        this.majorIsotopes = new HashMap();
    }

    @TestMethod(value="testGetInstance_IChemObjectBuilder")
    public static XMLIsotopeFactory getInstance(IChemObjectBuilder builder) throws IOException {
        if (ifac == null) {
            ifac = new XMLIsotopeFactory(builder);
        }
        return ifac;
    }
}

