/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash;

import java.util.BitSet;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;

@TestClass(value="org.openscience.cdk.hash.SupressedTest")
abstract class Suppressed {
    private static final Empty empty = new Empty();

    Suppressed() {
    }

    abstract boolean contains(int var1);

    abstract int count();

    abstract int[] toArray();

    @TestMethod(value="none")
    static Suppressed none() {
        return empty;
    }

    @TestMethod(value="bitset")
    static Suppressed fromBitSet(BitSet set) {
        return new SuppressedBitSet(set);
    }

    private static final class SuppressedBitSet
    extends Suppressed {
        private final BitSet set;

        private SuppressedBitSet(BitSet set) {
            this.set = set;
        }

        @Override
        boolean contains(int i) {
            return this.set.get(i);
        }

        @Override
        int count() {
            return this.set.cardinality();
        }

        @Override
        int[] toArray() {
            int[] xs = new int[this.count()];
            int n = 0;
            int i = this.set.nextSetBit(0);
            while (i >= 0) {
                xs[n++] = i;
                i = this.set.nextSetBit(i + 1);
            }
            return xs;
        }
    }

    private static final class Empty
    extends Suppressed {
        private Empty() {
        }

        @Override
        boolean contains(int i) {
            return false;
        }

        @Override
        int count() {
            return 0;
        }

        @Override
        int[] toArray() {
            return new int[0];
        }
    }
}

