/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.IntegerResult;

@TestClass(value="org.openscience.cdk.qsar.descriptors.atomic.AtomDegreeDescriptorTest")
public class AtomDegreeDescriptor
extends AbstractAtomicDescriptor
implements IAtomicDescriptor {
    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#atomDegree", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return new String[]{"aNeg"};
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtom atom, IAtomContainer container) {
        int atomDegree = 0;
        List<IAtom> neighboors = container.getConnectedAtomsList(atom);
        for (IAtom neighboor : neighboors) {
            if (neighboor.getSymbol().equals("H")) continue;
            ++atomDegree;
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(atomDegree), this.getDescriptorNames());
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return new String[0];
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return null;
    }
}

