/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.group;

import java.util.SortedSet;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.group.DisjointSetForest;
import org.openscience.cdk.group.IEquitablePartitionRefiner;
import org.openscience.cdk.group.Partition;
import org.openscience.cdk.group.Permutation;
import org.openscience.cdk.group.PermutationGroup;

@TestClass(value="org.openscience.cdk.group.AbstractDiscretePartitionRefinerTest")
public abstract class AbstractDiscretePartitionRefiner {
    private boolean bestExist = false;
    private Permutation best = null;
    private Permutation first;
    private IEquitablePartitionRefiner equitableRefiner = null;
    private PermutationGroup group;

    @TestMethod(value="emptyConstructor")
    public AbstractDiscretePartitionRefiner() {
    }

    public abstract int getVertexCount();

    public abstract int getConnectivity(int var1, int var2);

    @TestMethod(value="setupTest")
    public void setup(PermutationGroup group, IEquitablePartitionRefiner refiner) {
        this.bestExist = false;
        this.best = null;
        this.group = group;
        this.equitableRefiner = refiner;
    }

    @TestMethod(value="firstIsIdentityTest")
    public boolean firstIsIdentity() {
        return this.first.isIdentity();
    }

    @TestMethod(value="getAutomorphismPartitionTest")
    public Partition getAutomorphismPartition() {
        final int n = this.group.getSize();
        final DisjointSetForest forest = new DisjointSetForest(n);
        this.group.apply(new PermutationGroup.Backtracker(){
            boolean[] inOrbit;
            private int inOrbitCount;
            private boolean isFinished;
            {
                this.inOrbit = new boolean[n];
                this.inOrbitCount = 0;
            }

            @Override
            public boolean isFinished() {
                return this.isFinished;
            }

            @Override
            public void applyTo(Permutation p) {
                for (int elementX = 0; elementX < n; ++elementX) {
                    if (this.inOrbit[elementX]) continue;
                    int elementY = p.get(elementX);
                    while (elementY != elementX) {
                        if (!this.inOrbit[elementY]) {
                            ++this.inOrbitCount;
                            this.inOrbit[elementY] = true;
                            forest.makeUnion(elementX, elementY);
                        }
                        elementY = p.get(elementY);
                    }
                }
                if (this.inOrbitCount == n) {
                    this.isFinished = true;
                }
            }
        });
        Partition partition = new Partition();
        for (int[] set : forest.getSets()) {
            partition.addCell(set);
        }
        partition.order();
        return partition;
    }

    @TestMethod(value="getHalfMatrixStringTest")
    public String getHalfMatrixString(Permutation permutation) {
        StringBuilder builder = new StringBuilder(permutation.size());
        int size = permutation.size();
        for (int indexI = 0; indexI < size - 1; ++indexI) {
            for (int indexJ = indexI + 1; indexJ < size; ++indexJ) {
                builder.append(this.getConnectivity(permutation.get(indexI), permutation.get(indexJ)));
            }
        }
        return builder.toString();
    }

    @TestMethod(value="getHalfMatrixStringTest")
    public String getBestHalfMatrixString() {
        return this.getHalfMatrixString(this.best);
    }

    @TestMethod(value="getFirstMatrixStringTest")
    public String getFirstHalfMatrixString() {
        return this.getHalfMatrixString(this.first);
    }

    @TestMethod(value="getHalfMatrixStringTest")
    public String getHalfMatrixString() {
        return this.getHalfMatrixString(new Permutation(this.getVertexCount()));
    }

    @TestMethod(value="getGroupTest")
    public PermutationGroup getAutomorphismGroup() {
        return this.group;
    }

    @TestMethod(value="getBestTest")
    public Permutation getBest() {
        return this.best;
    }

    @TestMethod(value="getFirstTest")
    public Permutation getFirst() {
        return this.first;
    }

    @TestMethod(value="isCanonical_TrueTest,isCanonical_FalseTest")
    public boolean isCanonical() {
        return this.best.isIdentity();
    }

    @TestMethod(value="refineTest")
    public void refine(Partition partition) {
        this.refine(this.group, partition);
    }

    private void refine(PermutationGroup group, Partition coarser) {
        block9: {
            Result result;
            int firstNonDiscreteCell;
            Partition finer;
            int vertexCount;
            block7: {
                Permutation pi1;
                block10: {
                    block8: {
                        vertexCount = this.getVertexCount();
                        finer = this.equitableRefiner.refine(coarser);
                        firstNonDiscreteCell = finer.getIndexOfFirstNonDiscreteCell();
                        if (firstNonDiscreteCell == -1) {
                            firstNonDiscreteCell = vertexCount;
                        }
                        pi1 = new Permutation(firstNonDiscreteCell);
                        result = Result.BETTER;
                        if (this.bestExist) {
                            pi1 = finer.setAsPermutation(firstNonDiscreteCell);
                            result = this.compareRowwise(pi1);
                        }
                        if (finer.size() != vertexCount) break block7;
                        if (this.bestExist) break block8;
                        this.best = finer.toPermutation();
                        this.first = finer.toPermutation();
                        this.bestExist = true;
                        break block9;
                    }
                    if (result != Result.BETTER) break block10;
                    this.best = new Permutation(pi1);
                    break block9;
                }
                if (result != Result.EQUAL) break block9;
                group.enter(pi1.multiply(this.best.invert()));
                break block9;
            }
            if (result != Result.WORSE) {
                SortedSet<Integer> blockCopy = finer.copyBlock(firstNonDiscreteCell);
                for (int vertexInBlock = 0; vertexInBlock < vertexCount; ++vertexInBlock) {
                    if (!blockCopy.contains(vertexInBlock)) continue;
                    Partition nextPartition = finer.splitBefore(firstNonDiscreteCell, vertexInBlock);
                    this.refine(group, nextPartition);
                    int[] permF = new int[vertexCount];
                    int[] invF = new int[vertexCount];
                    for (int i = 0; i < vertexCount; ++i) {
                        permF[i] = i;
                        invF[i] = i;
                    }
                    int j = 0;
                    while (j <= firstNonDiscreteCell) {
                        int x = nextPartition.getFirstInCell(j);
                        int i = invF[x];
                        int h = permF[j];
                        permF[j] = x;
                        permF[i] = h;
                        invF[h] = i;
                        invF[x] = j++;
                    }
                    Permutation pPermF = new Permutation(permF);
                    group.changeBase(pPermF);
                    for (int j2 = 0; j2 < vertexCount; ++j2) {
                        Permutation g = group.get(firstNonDiscreteCell, j2);
                        if (g == null) continue;
                        blockCopy.remove(g.get(vertexInBlock));
                    }
                }
            }
        }
    }

    private Result compareRowwise(Permutation perm) {
        int m = perm.size();
        for (int i = 0; i < m - 1; ++i) {
            for (int j = i + 1; j < m; ++j) {
                int y;
                int x = this.getConnectivity(this.best.get(i), this.best.get(j));
                if (x > (y = this.getConnectivity(perm.get(i), perm.get(j)))) {
                    return Result.WORSE;
                }
                if (x >= y) continue;
                return Result.BETTER;
            }
        }
        return Result.EQUAL;
    }

    public static enum Result {
        WORSE,
        EQUAL,
        BETTER;

    }
}

