/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.List;
import uk.ac.ebi.beam.AbstractFunction;
import uk.ac.ebi.beam.Atom;
import uk.ac.ebi.beam.AtomImpl;
import uk.ac.ebi.beam.Configuration;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;
import uk.ac.ebi.beam.Topology;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ToSubsetAtoms
extends AbstractFunction<Graph, Graph> {
    ToSubsetAtoms() {
    }

    @Override
    public Graph apply(Graph g) {
        Graph h = new Graph(g.order());
        for (int u = 0; u < g.order(); ++u) {
            Topology t = g.topologyOf(u);
            if (t.type() == Configuration.Type.None) {
                h.addAtom(ToSubsetAtoms.toSubset(g.atom(u), this.bondOrderSum(g.edges(u), g)));
                continue;
            }
            h.addAtom(g.atom(u));
            h.addTopology(t);
        }
        for (Edge e : g.edges()) {
            h.addEdge(e);
        }
        return h;
    }

    static Atom toSubset(Atom a, int sum) {
        int impliedHCount;
        if (a.subset()) {
            return a;
        }
        if (!a.element().organic()) {
            return a;
        }
        if (a.charge() != 0 || a.atomClass() != 0 || a.isotope() >= 0) {
            return a;
        }
        int n = impliedHCount = a.aromatic() ? a.element().aromaticImplicitHydrogens(sum + 1) : a.element().implicitHydrogens(sum);
        if (impliedHCount != a.hydrogens()) {
            return a;
        }
        if (a.aromatic()) {
            return AtomImpl.AromaticSubset.ofElement(a.element());
        }
        return AtomImpl.AliphaticSubset.ofElement(a.element());
    }

    private int bondOrderSum(List<Edge> es, Graph g) {
        int sum = 0;
        for (Edge e : es) {
            sum += e.bond().order();
        }
        return sum;
    }
}

