/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.pharmacophore;

import org.openscience.cdk.Bond;
import org.openscience.cdk.pharmacophore.PharmacophoreAtom;

public class PharmacophoreAngleBond
extends Bond {
    public PharmacophoreAngleBond(PharmacophoreAtom patom1, PharmacophoreAtom patom2, PharmacophoreAtom patom3) {
        super(new PharmacophoreAtom[]{patom1, patom2, patom3});
    }

    public double getBondLength() {
        double c2;
        double epsilon = 0.001;
        PharmacophoreAtom atom1 = (PharmacophoreAtom)this.getAtom(0);
        PharmacophoreAtom atom2 = (PharmacophoreAtom)this.getAtom(1);
        PharmacophoreAtom atom3 = (PharmacophoreAtom)this.getAtom(2);
        double a2 = atom3.getPoint3d().distanceSquared(atom1.getPoint3d());
        double b2 = atom3.getPoint3d().distanceSquared(atom2.getPoint3d());
        double cosangle = (b2 + (c2 = atom2.getPoint3d().distanceSquared(atom1.getPoint3d())) - a2) / (2.0 * Math.sqrt(b2) * Math.sqrt(c2));
        if (-1.0 - epsilon < cosangle && -1.0 + epsilon > cosangle) {
            return 180.0;
        }
        if (1.0 - epsilon < cosangle && 1.0 + epsilon > cosangle) {
            return 0.0;
        }
        return Math.acos(cosangle) * 180.0 / Math.PI;
    }
}

