/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.cml;

import java.util.StringTokenizer;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.io.cml.CMLCoreModule;
import org.openscience.cdk.io.cml.CMLStack;
import org.openscience.cdk.io.cml.ICMLModule;
import org.openscience.cdk.tools.manipulator.BondManipulator;
import org.xml.sax.Attributes;

public class CDKConvention
extends CMLCoreModule {
    private boolean isBond;

    public CDKConvention(IChemFile chemFile) {
        super(chemFile);
    }

    public CDKConvention(ICMLModule conv) {
        super(conv);
    }

    @Override
    public void startDocument() {
        super.startDocument();
        this.isBond = false;
    }

    @Override
    public void startElement(CMLStack xpath, String uri, String local, String raw, Attributes atts) {
        this.isBond = false;
        if (xpath.toString().endsWith("string/")) {
            for (int i = 0; i < atts.getLength(); ++i) {
                if (!atts.getQName(i).equals("buildin") || !atts.getValue(i).equals("order")) continue;
                this.isBond = true;
            }
        } else {
            super.startElement(xpath, uri, local, raw, atts);
        }
    }

    @Override
    public void characterData(CMLStack xpath, char[] ch, int start, int length) {
        String s = new String(ch, start, length).trim();
        if (this.isBond) {
            this.logger.debug("CharData (bond): " + s);
            StringTokenizer st = new StringTokenizer(s);
            while (st.hasMoreElements()) {
                String border = (String)st.nextElement();
                this.logger.debug("new bond order: " + border);
                this.currentBond.setOrder(BondManipulator.createBondOrder(Double.parseDouble(border)));
            }
        } else {
            super.characterData(xpath, ch, start, length);
        }
    }
}

