/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceRequiredException;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.impl.LiteralImpl;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.impl.StatementImpl;
import com.hp.hpl.jena.shared.JenaException;

public abstract class StatementBase {
    protected final ModelCom model;

    protected StatementBase(ModelCom model) {
        if (model == null) {
            throw new JenaException("Statement models must no be null");
        }
        this.model = model;
    }

    public Model getModel() {
        return this.model;
    }

    protected abstract StatementImpl replace(RDFNode var1);

    public abstract Literal getLiteral();

    public abstract Resource getResource();

    public abstract Resource getSubject();

    public abstract Property getPredicate();

    public abstract RDFNode getObject();

    protected StatementImpl stringReplace(String s, String lang, boolean wellFormed) {
        return this.replace(new LiteralImpl(Node.createLiteral(s, lang, wellFormed), this.model));
    }

    protected StatementImpl stringReplace(String s) {
        return this.stringReplace(s, "", false);
    }

    public Statement changeLiteralObject(boolean o) {
        return this.changeObject(this.model.createTypedLiteral(o));
    }

    public Statement changeLiteralObject(long o) {
        return this.changeObject(this.model.createTypedLiteral(o));
    }

    public Statement changeLiteralObject(char o) {
        return this.changeObject(this.model.createTypedLiteral(o));
    }

    public Statement changeLiteralObject(double o) {
        return this.changeObject(this.model.createTypedLiteral(o));
    }

    public Statement changeLiteralObject(float o) {
        return this.changeObject(this.model.createTypedLiteral(o));
    }

    public Statement changeLiteralObject(int o) {
        return this.changeObject(this.model.createTypedLiteral(o));
    }

    public Statement changeObject(String o) {
        return this.stringReplace(String.valueOf(o));
    }

    public Statement changeObject(String o, boolean wellFormed) {
        return this.stringReplace(String.valueOf(o), "", wellFormed);
    }

    public Statement changeObject(String o, String l) {
        return this.stringReplace(String.valueOf(o), l, false);
    }

    public Statement changeObject(String o, String l, boolean wellFormed) {
        return this.stringReplace(String.valueOf(o), l, wellFormed);
    }

    public Statement changeObject(RDFNode o) {
        return this.replace(o);
    }

    public boolean getBoolean() {
        return this.getLiteral().getBoolean();
    }

    public byte getByte() {
        return this.getLiteral().getByte();
    }

    public short getShort() {
        return this.getLiteral().getShort();
    }

    public int getInt() {
        return this.getLiteral().getInt();
    }

    public long getLong() {
        return this.getLiteral().getLong();
    }

    public char getChar() {
        return this.getLiteral().getChar();
    }

    public float getFloat() {
        return this.getLiteral().getFloat();
    }

    public double getDouble() {
        return this.getLiteral().getDouble();
    }

    public String getString() {
        return this.getLiteral().getLexicalForm();
    }

    protected Resource mustBeResource(RDFNode n) {
        if (n instanceof Resource) {
            return (Resource)n;
        }
        throw new ResourceRequiredException(n);
    }

    public String getLanguage() {
        return this.getLiteral().getLanguage();
    }

    public boolean getWellFormed() {
        return this.hasWellFormedXML();
    }

    public boolean hasWellFormedXML() {
        return this.getLiteral().isWellFormedXML();
    }

    public String toString() {
        return "[" + this.getSubject().toString() + ", " + this.getPredicate().toString() + ", " + this.objectString(this.getObject()) + "]";
    }

    protected String objectString(RDFNode object) {
        return object.asNode().toString(null, true);
    }
}

