/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.ring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smsd.algorithm.matchers.AtomMatcher;
import org.openscience.cdk.smsd.ring.RingFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RingFilter {
    private RingFinder ringFinder;
    private Comparator comparator;
    private AtomMatcher filter;
    private IAtomContainer mol;

    public RingFilter(AtomMatcher filter, RingFinder finder) {
        this.ringFinder = finder;
        this.comparator = new RingSizeComparator();
        this.filter = filter;
    }

    public void filterAtoms(int atomLimit, Collection<List<IAtom>> rings, Collection<IAtom> atoms) {
        for (List<IAtom> ring : rings) {
            if (atoms.size() >= atomLimit) break;
            if (!this.ringMatches(ring)) continue;
            atoms.addAll(ring);
        }
    }

    public void filterAtoms(IAtomContainer molecule, Collection<IAtom> atoms) {
        this.mol = molecule;
        ArrayList<List<IAtom>> rings = new ArrayList<List<IAtom>>(this.ringFinder.findRings(molecule));
        Collections.sort(rings, this.comparator);
        for (List list : rings) {
            if (atoms.size() == molecule.getAtomCount()) break;
            if (!this.ringMatches(list)) continue;
            atoms.addAll(list);
        }
    }

    private boolean ringMatches(List<IAtom> ring) {
        for (IAtom atom : ring) {
            if (this.filter.matches(this.mol, atom)) continue;
            return false;
        }
        return true;
    }

    private class RingSizeComparator
    implements Comparator {
        private RingSizeComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((List)o1).size() - ((List)o2).size();
        }
    }
}

