/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.matchers;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryChemObject {
    private List<IChemObjectListener> chemObjectListeners = null;
    private Map<Object, Object> properties = null;
    private String identifier = null;
    private boolean[] flags = new boolean[13];
    private boolean doNotification = true;

    private List<IChemObjectListener> lazyChemObjectListeners() {
        if (this.chemObjectListeners == null) {
            this.chemObjectListeners = new ArrayList<IChemObjectListener>();
        }
        return this.chemObjectListeners;
    }

    public void addListener(IChemObjectListener col) {
        List<IChemObjectListener> listeners = this.lazyChemObjectListeners();
        if (!listeners.contains(col)) {
            listeners.add(col);
        }
    }

    public int getListenerCount() {
        if (this.chemObjectListeners == null) {
            return 0;
        }
        return this.lazyChemObjectListeners().size();
    }

    public void removeListener(IChemObjectListener col) {
        if (this.chemObjectListeners == null) {
            return;
        }
        List<IChemObjectListener> listeners = this.lazyChemObjectListeners();
        if (listeners.contains(col)) {
            listeners.remove(col);
        }
    }

    public void notifyChanged() {
        if (this.getNotification() && this.getListenerCount() > 0) {
            List<IChemObjectListener> listeners = this.lazyChemObjectListeners();
            for (IChemObjectListener listener : listeners) {
                listener.stateChanged(new QueryChemObjectChangeEvent(this));
            }
        }
    }

    public void notifyChanged(IChemObjectChangeEvent evt) {
        if (this.getNotification() && this.getListenerCount() > 0) {
            List<IChemObjectListener> listeners = this.lazyChemObjectListeners();
            for (IChemObjectListener listener : listeners) {
                listener.stateChanged(evt);
            }
        }
    }

    private Map<Object, Object> lazyProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<Object, Object>();
        }
        return this.properties;
    }

    public void setProperty(Object description, Object property) {
        this.lazyProperties().put(description, property);
        this.notifyChanged();
    }

    public void removeProperty(Object description) {
        if (this.properties == null) {
            return;
        }
        if (this.lazyProperties().remove(description) != null) {
            this.notifyChanged();
        }
    }

    public Object getProperty(Object description) {
        if (this.properties != null) {
            return this.lazyProperties().get(description);
        }
        return null;
    }

    public Map<Object, Object> getProperties() {
        return this.lazyProperties();
    }

    public String getID() {
        return this.identifier;
    }

    public void setID(String identifier) {
        this.identifier = identifier;
        this.notifyChanged();
    }

    public void setFlag(int flag_type, boolean flag_value) {
        this.flags[flag_type] = flag_value;
        this.notifyChanged();
    }

    public boolean getFlag(int flag_type) {
        return this.flags[flag_type];
    }

    public void setProperties(Map<Object, Object> properties) {
        for (Object key : properties.keySet()) {
            this.lazyProperties().put(key, properties.get(key));
        }
        this.notifyChanged();
    }

    public void setFlags(boolean[] flagsNew) {
        this.flags = flagsNew;
    }

    public boolean[] getFlags() {
        return this.flags;
    }

    public void setNotification(boolean bool) {
        this.doNotification = bool;
    }

    public boolean getNotification() {
        return this.doNotification;
    }

    public IChemObjectBuilder getBuilder() {
        throw new IllegalAccessError();
    }

    public boolean matches(IAtom atom) {
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    class QueryChemObjectChangeEvent
    extends EventObject
    implements IChemObjectChangeEvent {
        private static final long serialVersionUID = 8060005185140623245L;

        public QueryChemObjectChangeEvent(Object source) {
            super(source);
        }
    }
}

