/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.lang.reflect.Method;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.atomtype.EStateAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.tools.AtomicProperties;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.BondManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.ALOGPDescriptorTest")
public class ALOGPDescriptor
implements IMolecularDescriptor {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(ALOGPDescriptor.class);
    IAtomContainer atomContainer;
    IRingSet rs;
    String[] fragment;
    AtomicProperties ap;
    int[] frags = new int[121];
    public int[] alogpfrag;
    static final double[] fragval = new double[121];
    static final double[] refracval;
    String UnassignedAtoms = "";
    double ALOGP = 0.0;
    double AMR = 0.0;
    double ALOGP2 = 0.0;
    private static final String[] strings;

    public ALOGPDescriptor() throws CDKException {
        try {
            this.ap = AtomicProperties.getInstance();
        }
        catch (Exception e) {
            logger.debug("Problem in accessing atomic properties. Can't calculate");
            throw new CDKException("Problem in accessing atomic properties. Can't calculate\n" + e.getMessage(), e);
        }
    }

    private void findUnassignedAtoms() {
        this.UnassignedAtoms = "";
        for (int i = 0; i <= this.atomContainer.getAtomCount() - 1; ++i) {
            if (this.alogpfrag[i] != 0) continue;
            this.UnassignedAtoms = this.UnassignedAtoms + (i + 1) + "(" + this.fragment[i] + "),";
        }
    }

    private double[] calculate(IAtomContainer atomContainer, String[] fragment, IRingSet rs) throws CDKException {
        int i;
        this.atomContainer = atomContainer;
        this.fragment = fragment;
        this.rs = rs;
        this.ALOGP = 0.0;
        this.AMR = 0.0;
        this.ALOGP2 = 0.0;
        this.alogpfrag = new int[atomContainer.getAtomCount()];
        for (i = 1; i <= 120; ++i) {
            this.frags[i] = 0;
        }
        for (i = 0; i <= atomContainer.getAtomCount() - 1; ++i) {
            this.alogpfrag[i] = 0;
            try {
                Method[] methods = this.getClass().getDeclaredMethods();
                if (!(fragment[i] instanceof String)) continue;
                for (int j = 0; j <= methods.length - 1; ++j) {
                    Method method = methods[j];
                    if (method.getName().equals("calculate") || !method.getName().startsWith("calc")) continue;
                    Object[] objs = new Object[]{i};
                    method.invoke((Object)this, objs);
                }
                continue;
            }
            catch (Exception e) {
                throw new CDKException(e.toString(), e);
            }
        }
        logger.debug("\nFound fragments and frequencies ");
        for (i = 1; i <= 120; ++i) {
            this.ALOGP += fragval[i] * (double)this.frags[i];
            this.AMR += refracval[i] * (double)this.frags[i];
            if (this.frags[i] <= 0) continue;
            logger.debug("frag " + i + "  --> " + this.frags[i]);
        }
        this.ALOGP2 = this.ALOGP * this.ALOGP;
        this.findUnassignedAtoms();
        return new double[]{this.ALOGP, this.ALOGP2, this.AMR};
    }

    private void calcGroup001_005(int i) {
        if (this.fragment[i].equals("SsCH3")) {
            List<IAtom> ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
            int htype = this.getHAtomType(this.atomContainer.getAtom(i), ca);
            for (int j = 0; j < ca.size(); ++j) {
                if (ca.get(j).getSymbol().equals("C")) {
                    this.frags[1] = this.frags[1] + 1;
                    this.alogpfrag[i] = 1;
                    continue;
                }
                if (ca.get(j).getSymbol().equals("H")) {
                    int n = htype;
                    this.frags[n] = this.frags[n] + 1;
                    continue;
                }
                this.frags[5] = this.frags[5] + 1;
                this.alogpfrag[i] = 5;
            }
        }
    }

    private void calcGroup002_006_007(int i) {
        if (this.fragment[i].equals("SssCH2")) {
            List<IAtom> ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
            int htype = this.getHAtomType(this.atomContainer.getAtom(i), ca);
            int CarbonCount = 0;
            int HeteroCount = 0;
            for (int j = 0; j < ca.size(); ++j) {
                if (ca.get(j).getSymbol().equals("C")) {
                    ++CarbonCount;
                    continue;
                }
                if (ca.get(j).getSymbol().equals("H")) {
                    int n = htype;
                    this.frags[n] = this.frags[n] + 1;
                    continue;
                }
                ++HeteroCount;
            }
            if (CarbonCount == 2 && HeteroCount == 0) {
                this.frags[2] = this.frags[2] + 1;
                this.alogpfrag[i] = 2;
            } else if (CarbonCount == 1 && HeteroCount == 1) {
                this.frags[6] = this.frags[6] + 1;
                this.alogpfrag[i] = 6;
            } else if (CarbonCount == 0 && HeteroCount == 2) {
                this.frags[7] = this.frags[7] + 1;
                this.alogpfrag[i] = 7;
            }
        }
    }

    private void calcGroup003_008_009_010(int i) {
        if (this.fragment[i].equals("SsssCH")) {
            List<IAtom> ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
            int htype = this.getHAtomType(this.atomContainer.getAtom(i), ca);
            int CarbonCount = 0;
            int HeteroCount = 0;
            for (int j = 0; j <= ca.size() - 1; ++j) {
                if (ca.get(j).getSymbol().equals("C")) {
                    ++CarbonCount;
                    continue;
                }
                if (ca.get(j).getSymbol().equals("H")) {
                    int n = htype;
                    this.frags[n] = this.frags[n] + 1;
                    continue;
                }
                ++HeteroCount;
            }
            if (CarbonCount == 3 && HeteroCount == 0) {
                this.frags[3] = this.frags[3] + 1;
                this.alogpfrag[i] = 3;
            } else if (CarbonCount == 2 && HeteroCount == 1) {
                this.frags[8] = this.frags[8] + 1;
                this.alogpfrag[i] = 8;
            } else if (CarbonCount == 1 && HeteroCount == 2) {
                this.frags[9] = this.frags[9] + 1;
                this.alogpfrag[i] = 9;
            } else if (CarbonCount == 0 && HeteroCount == 3) {
                this.frags[10] = this.frags[10] + 1;
                this.alogpfrag[i] = 10;
            }
        }
    }

    private void calcGroup004_011_to_014(int i) {
        if (this.fragment[i].equals("SssssC")) {
            List<IAtom> ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
            int CarbonCount = 0;
            int HeteroCount = 0;
            for (int j = 0; j <= ca.size() - 1; ++j) {
                if (ca.get(j).getSymbol().equals("C")) {
                    ++CarbonCount;
                    continue;
                }
                ++HeteroCount;
            }
            if (CarbonCount == 4 && HeteroCount == 0) {
                this.frags[4] = this.frags[4] + 1;
                this.alogpfrag[i] = 4;
            } else if (CarbonCount == 3 && HeteroCount == 1) {
                this.frags[11] = this.frags[11] + 1;
                this.alogpfrag[i] = 11;
            } else if (CarbonCount == 2 && HeteroCount == 2) {
                this.frags[12] = this.frags[12] + 1;
                this.alogpfrag[i] = 12;
            } else if (CarbonCount == 1 && HeteroCount == 3) {
                this.frags[13] = this.frags[13] + 1;
                this.alogpfrag[i] = 13;
            } else if (CarbonCount == 0 && HeteroCount == 4) {
                this.frags[14] = this.frags[14] + 1;
                this.alogpfrag[i] = 14;
            }
        }
    }

    private void calcGroup015(int i) {
        if (this.fragment[i].equals("SdCH2")) {
            int htype;
            this.frags[15] = this.frags[15] + 1;
            this.alogpfrag[i] = 15;
            int n = htype = this.getHAtomType(this.atomContainer.getAtom(i), null);
            this.frags[n] = this.frags[n] + 2;
        }
    }

    private void calcGroup016_018_036_037(int i) {
        int htype;
        IAtom ai = this.atomContainer.getAtom(i);
        if (!this.fragment[i].equals("SdsCH")) {
            return;
        }
        List<IAtom> ca = this.atomContainer.getConnectedAtomsList(ai);
        int n = htype = this.getHAtomType(this.atomContainer.getAtom(i), ca);
        this.frags[n] = this.frags[n] + 1;
        boolean HaveCdX = false;
        boolean HaveCsX = false;
        boolean HaveCsAr = false;
        for (int j = 0; j <= ca.size() - 1; ++j) {
            if (ca.get(j).getSymbol().equals("H")) continue;
            if (this.atomContainer.getBond(ai, ca.get(j)).getOrder() == IBond.Order.SINGLE) {
                if (!ca.get(j).getSymbol().equals("C")) {
                    HaveCsX = true;
                }
                if (!ca.get(j).getFlag(32)) continue;
                HaveCsAr = true;
                continue;
            }
            if (this.atomContainer.getBond(ai, ca.get(j)).getOrder() != IBond.Order.DOUBLE || ca.get(j).getSymbol().equals("C")) continue;
            HaveCdX = true;
        }
        if (HaveCdX) {
            if (HaveCsAr) {
                this.frags[37] = this.frags[37] + 1;
                this.alogpfrag[i] = 37;
            } else {
                this.frags[36] = this.frags[36] + 1;
                this.alogpfrag[i] = 36;
            }
        } else if (HaveCsX) {
            this.frags[18] = this.frags[18] + 1;
            this.alogpfrag[i] = 18;
        } else {
            this.frags[16] = this.frags[16] + 1;
            this.alogpfrag[i] = 16;
        }
    }

    private void calcGroup017_019_020_038_to_041(int i) {
        IAtom ai = this.atomContainer.getAtom(i);
        if (!this.fragment[i].equals("SdssC")) {
            return;
        }
        List<IAtom> ca = this.atomContainer.getConnectedAtomsList(ai);
        int RCount = 0;
        int XCount = 0;
        boolean HaveCdX = false;
        int AliphaticCount = 0;
        int AromaticCount = 0;
        for (int j = 0; j <= ca.size() - 1; ++j) {
            if (this.atomContainer.getBond(ai, ca.get(j)).getOrder() == IBond.Order.SINGLE) {
                if (ca.get(j).getSymbol().equals("C")) {
                    ++RCount;
                } else {
                    ++XCount;
                }
                if (!ca.get(j).getFlag(32)) {
                    ++AliphaticCount;
                    continue;
                }
                ++AromaticCount;
                continue;
            }
            if (this.atomContainer.getBond(ai, ca.get(j)).getOrder() != IBond.Order.DOUBLE || ca.get(j).getSymbol().equals("C")) continue;
            HaveCdX = true;
        }
        if (HaveCdX) {
            if (AromaticCount >= 1) {
                this.frags[39] = this.frags[39] + 1;
                this.alogpfrag[i] = 39;
            } else if (AromaticCount == 0) {
                if (RCount == 1 && XCount == 1) {
                    this.frags[40] = this.frags[40] + 1;
                    this.alogpfrag[i] = 40;
                } else if (RCount == 0 && XCount == 2) {
                    this.frags[41] = this.frags[41] + 1;
                    this.alogpfrag[i] = 41;
                } else {
                    this.frags[38] = this.frags[38] + 1;
                    this.alogpfrag[i] = 38;
                }
            }
        } else if (RCount == 2 && XCount == 0) {
            this.frags[17] = this.frags[17] + 1;
            this.alogpfrag[i] = 17;
        } else if (RCount == 1 && XCount == 1) {
            this.frags[19] = this.frags[19] + 1;
            this.alogpfrag[i] = 19;
        } else if (RCount == 0 && XCount == 2) {
            this.frags[20] = this.frags[20] + 1;
            this.alogpfrag[i] = 20;
        }
    }

    private void calcGroup021_to_023_040(int i) {
        List<IAtom> ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
        IAtom ai = this.atomContainer.getAtom(i);
        if (this.fragment[i].equals("StCH")) {
            int htype;
            this.frags[21] = this.frags[21] + 1;
            this.alogpfrag[i] = 21;
            int n = htype = this.getHAtomType(this.atomContainer.getAtom(i), ca);
            this.frags[n] = this.frags[n] + 1;
        } else if (this.fragment[i].equals("SddC")) {
            if (ca.get(0).getSymbol().equals("C") && ca.get(1).getSymbol().equals("C")) {
                this.frags[22] = this.frags[22] + 1;
                this.alogpfrag[i] = 22;
            } else if (!ca.get(0).getSymbol().equals("C") && !ca.get(1).getSymbol().equals("C")) {
                this.frags[40] = this.frags[40] + 1;
                this.alogpfrag[i] = 40;
            }
        } else if (this.fragment[i].equals("StsC")) {
            boolean HaveCtX = false;
            boolean HaveCsX = false;
            for (int j = 0; j <= ca.size() - 1; ++j) {
                if (this.atomContainer.getBond(ai, ca.get(j)).getOrder() == IBond.Order.SINGLE) {
                    if (ca.get(j).getSymbol().equals("C")) continue;
                    HaveCsX = true;
                    continue;
                }
                if (this.atomContainer.getBond(ai, ca.get(j)).getOrder() != IBond.Order.TRIPLE || ca.get(j).getSymbol().equals("C")) continue;
                HaveCtX = true;
            }
            if (HaveCtX && !HaveCsX) {
                this.frags[40] = this.frags[40] + 1;
                this.alogpfrag[i] = 40;
            } else if (HaveCsX) {
                this.frags[23] = this.frags[23] + 1;
                this.alogpfrag[i] = 23;
            } else if (!HaveCsX) {
                this.frags[22] = this.frags[22] + 1;
                this.alogpfrag[i] = 22;
            }
        }
    }

    private void calcGroup024_027_030_033_042(int i) {
        IAtom ca1;
        IAtom ca0;
        int htype;
        if (!this.fragment[i].equals("SaaCH")) {
            return;
        }
        List<IAtom> ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
        int n = htype = this.getHAtomType(this.atomContainer.getAtom(i), ca);
        this.frags[n] = this.frags[n] + 1;
        if (ca.get(0).getSymbol().equals("H")) {
            ca0 = ca.get(1);
            ca1 = ca.get(2);
        } else if (ca.get(1).getSymbol().equals("H")) {
            ca0 = ca.get(0);
            ca1 = ca.get(2);
        } else {
            ca0 = ca.get(0);
            ca1 = ca.get(1);
        }
        if (ca0.getSymbol().equals("C") && ca1.getSymbol().equals("C")) {
            this.frags[24] = this.frags[24] + 1;
            this.alogpfrag[i] = 24;
            return;
        }
        List<IBond> bonds = this.atomContainer.getConnectedBondsList(ca0);
        boolean HaveDouble1 = false;
        for (int k = 0; k <= bonds.size() - 1; ++k) {
            if (bonds.get(k).getOrder() != IBond.Order.DOUBLE) continue;
            HaveDouble1 = true;
            break;
        }
        bonds = this.atomContainer.getConnectedBondsList(ca1);
        boolean HaveDouble2 = false;
        for (int k = 0; k <= bonds.size() - 1; ++k) {
            if (bonds.get(k).getOrder() != IBond.Order.DOUBLE) continue;
            HaveDouble2 = true;
            break;
        }
        if (!ca0.getSymbol().equals("C") && !ca.get(1).getSymbol().equals("C")) {
            if (HaveDouble1 && HaveDouble2) {
                this.frags[30] = this.frags[30] + 1;
                this.alogpfrag[i] = 30;
            } else {
                this.frags[42] = this.frags[42] + 1;
                this.alogpfrag[i] = 42;
            }
        } else if (ca0.getSymbol().equals("C") && !ca1.getSymbol().equals("C") || !ca0.getSymbol().equals("C") && ca1.getSymbol().equals("C")) {
            if (HaveDouble1 && HaveDouble2) {
                this.frags[27] = this.frags[27] + 1;
                this.alogpfrag[i] = 27;
            } else {
                this.frags[33] = this.frags[33] + 1;
                this.alogpfrag[i] = 33;
            }
        }
    }

    private void calcGroup025_026_028_029_031_032_034_035_043_044(int i) {
        if (!this.fragment[i].equals("SsaaC") && !this.fragment[i].equals("SaaaC")) {
            return;
        }
        IAtom ai = this.atomContainer.getAtom(i);
        List<IAtom> ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
        IAtom[] sameringatoms = new IAtom[2];
        IAtom nonringatom = this.atomContainer.getBuilder().newInstance(IAtom.class, new Object[0]);
        int sameringatomscount = 0;
        for (int j = 0; j <= ca.size() - 1; ++j) {
            if (!this.inSameAromaticRing(this.atomContainer, ai, ca.get(j), this.rs)) continue;
            ++sameringatomscount;
        }
        if (sameringatomscount == 2) {
            int count = 0;
            for (int j = 0; j <= ca.size() - 1; ++j) {
                if (this.inSameAromaticRing(this.atomContainer, ai, ca.get(j), this.rs)) {
                    sameringatoms[count] = ca.get(j);
                    ++count;
                    continue;
                }
                nonringatom = ca.get(j);
            }
        } else {
            sameringatoms[0] = ca.get(0);
            sameringatoms[1] = ca.get(1);
            nonringatom = ca.get(2);
        }
        List<IBond> bonds = this.atomContainer.getConnectedBondsList(sameringatoms[0]);
        boolean HaveDouble1 = false;
        for (int k = 0; k <= bonds.size() - 1; ++k) {
            if (bonds.get(k).getOrder() != IBond.Order.DOUBLE) continue;
            HaveDouble1 = true;
            break;
        }
        bonds = this.atomContainer.getConnectedBondsList(sameringatoms[1]);
        boolean HaveDouble2 = false;
        for (int k = 0; k <= bonds.size() - 1; ++k) {
            if (bonds.get(k).getOrder() != IBond.Order.DOUBLE) continue;
            HaveDouble2 = true;
            break;
        }
        if (!sameringatoms[0].getSymbol().equals("C") && !sameringatoms[1].getSymbol().equals("C")) {
            if (HaveDouble1 && HaveDouble2) {
                if (nonringatom.getSymbol().equals("C")) {
                    this.frags[31] = this.frags[31] + 1;
                    this.alogpfrag[i] = 31;
                } else {
                    this.frags[32] = this.frags[32] + 1;
                    this.alogpfrag[i] = 32;
                }
            } else if (nonringatom.getSymbol().equals("C")) {
                this.frags[43] = this.frags[43] + 1;
                this.alogpfrag[i] = 43;
            } else {
                this.frags[44] = this.frags[44] + 1;
                this.alogpfrag[i] = 44;
            }
        } else if (sameringatoms[0].getSymbol().equals("C") && sameringatoms[1].getSymbol().equals("C")) {
            if (nonringatom.getSymbol().equals("C")) {
                this.frags[25] = this.frags[25] + 1;
                this.alogpfrag[i] = 25;
            } else {
                this.frags[26] = this.frags[26] + 1;
                this.alogpfrag[i] = 26;
            }
        } else if (sameringatoms[0].getSymbol().equals("C") && !sameringatoms[1].getSymbol().equals("C") || !sameringatoms[0].getSymbol().equals("C") && sameringatoms[1].getSymbol().equals("C")) {
            if (HaveDouble1 && HaveDouble2) {
                if (nonringatom.getSymbol().equals("C")) {
                    this.frags[28] = this.frags[28] + 1;
                    this.alogpfrag[i] = 28;
                } else {
                    this.frags[29] = this.frags[29] + 1;
                    this.alogpfrag[i] = 29;
                }
            } else if (nonringatom.getSymbol().equals("C")) {
                this.frags[34] = this.frags[34] + 1;
                this.alogpfrag[i] = 34;
            } else {
                this.frags[35] = this.frags[35] + 1;
                this.alogpfrag[i] = 35;
            }
        }
    }

    private int getHAtomType(IAtom ai, List connectedAtoms) {
        List<IAtom> ca = connectedAtoms == null ? this.atomContainer.getConnectedAtomsList(ai) : connectedAtoms;
        if (ai.getSymbol().equals("C") && !ai.getFlag(32)) {
            for (int j = 0; j <= ca.size() - 1; ++j) {
                if (this.atomContainer.getBond(ai, ca.get(j)).getOrder() != IBond.Order.SINGLE || !ca.get(j).getSymbol().equals("C")) continue;
                List<IAtom> ca2 = this.atomContainer.getConnectedAtomsList(ca.get(j));
                for (int k = 0; k <= ca2.size() - 1; ++k) {
                    IAtom ca2k = ca2.get(k);
                    if (ca2k.getSymbol().equals("C")) continue;
                    if (this.atomContainer.getBond(ca.get(j), ca2k).getOrder() != IBond.Order.SINGLE) {
                        return 51;
                    }
                    if (!ca.get(j).getFlag(32) || !ca2k.getFlag(32) || !this.inSameAromaticRing(this.atomContainer, ca.get(j), ca2k, this.rs)) continue;
                    return 51;
                }
            }
        }
        List<IBond> bonds = this.atomContainer.getConnectedBondsList(ai);
        int doublebondcount = 0;
        int triplebondcount = 0;
        String hybrid = "";
        for (int j = 0; j <= bonds.size() - 1; ++j) {
            if (bonds.get(j).getOrder() == IBond.Order.DOUBLE) {
                ++doublebondcount;
                continue;
            }
            if (bonds.get(j).getOrder() != IBond.Order.TRIPLE) continue;
            ++triplebondcount;
        }
        if (doublebondcount == 0 && triplebondcount == 0) {
            hybrid = "sp3";
        } else if (doublebondcount == 1 && triplebondcount == 0) {
            hybrid = "sp2";
        } else if (doublebondcount == 2 || triplebondcount == 1) {
            hybrid = "sp";
        }
        int OxNum = 0;
        int XCount = 0;
        for (int j = 0; j <= ca.size() - 1; ++j) {
            if (this.ap.getNormalizedElectronegativity(ca.get(j).getSymbol()) > 1.0) {
                List<IBond> bonds2 = this.atomContainer.getConnectedBondsList(ca.get(j));
                boolean HaveDouble = false;
                for (int k = 0; k <= bonds2.size() - 1; ++k) {
                    if (bonds2.get(k).getOrder() != IBond.Order.DOUBLE) continue;
                    HaveDouble = true;
                    break;
                }
                OxNum = HaveDouble && ca.get(j).getSymbol().equals("N") ? (OxNum += 2) : (int)((double)OxNum + BondManipulator.destroyBondOrder(this.atomContainer.getBond(ai, ca.get(j)).getOrder()));
            }
            List<IAtom> ca2 = this.atomContainer.getConnectedAtomsList(ca.get(j));
            for (int k = 0; k <= ca2.size() - 1; ++k) {
                String s2 = ca2.get(k).getSymbol();
                if (s2.equals("C")) continue;
                ++XCount;
            }
        }
        if (OxNum == 0) {
            if (hybrid.equals("sp3")) {
                if (XCount == 0) {
                    return 46;
                }
                if (XCount == 1) {
                    return 52;
                }
                if (XCount == 2) {
                    return 53;
                }
                if (XCount == 3) {
                    return 54;
                }
                if (XCount >= 4) {
                    return 55;
                }
            } else if (hybrid.equals("sp2")) {
                return 47;
            }
        } else {
            if (OxNum == 1 && hybrid.equals("sp3")) {
                return 47;
            }
            if (OxNum == 2 && hybrid.equals("sp3") || OxNum == 1 && hybrid.equals("sp2") || OxNum == 0 && hybrid.equals("sp")) {
                return 48;
            }
            if (OxNum == 3 && hybrid.equals("sp3") || OxNum >= 2 && hybrid.equals("sp2") || OxNum >= 1 && hybrid.equals("sp")) {
                return 49;
            }
        }
        return 0;
    }

    private void calcGroup056_57(int i) {
        if (!this.fragment[i].equals("SsOH")) {
            return;
        }
        List<IAtom> ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
        this.frags[50] = this.frags[50] + 1;
        IAtom ca0 = ca.get(0);
        if (ca0.getSymbol().equals("H")) {
            ca0 = ca.get(1);
        }
        if (ca0.getFlag(32)) {
            this.frags[57] = this.frags[57] + 1;
            this.alogpfrag[i] = 57;
            return;
        }
        List<IAtom> ca2 = this.atomContainer.getConnectedAtomsList(ca0);
        for (int j = 0; j <= ca2.size() - 1; ++j) {
            if (this.atomContainer.getBond(ca2.get(j), ca0).getOrder() != IBond.Order.DOUBLE) continue;
            this.frags[57] = this.frags[57] + 1;
            this.alogpfrag[i] = 57;
            return;
        }
        this.frags[56] = this.frags[56] + 1;
        this.alogpfrag[i] = 56;
    }

    private void calcGroup058_61(int i) {
        List<IAtom> ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
        IAtom ca0 = ca.get(0);
        if (this.fragment[i].equals("SsOm")) {
            if (ca0.getSymbol().equals("N") && ca0.getFormalCharge() == 1) {
                this.frags[61] = this.frags[61] + 1;
                this.alogpfrag[i] = 61;
            } else {
                this.frags[62] = this.frags[62] + 1;
                this.alogpfrag[i] = 62;
            }
        } else if (this.fragment[i].equals("SdO")) {
            if (ca0.getSymbol().equals("N") && ca0.getFormalCharge() == 1) {
                this.frags[61] = this.frags[61] + 1;
                this.alogpfrag[i] = 61;
            } else {
                this.frags[58] = this.frags[58] + 1;
                this.alogpfrag[i] = 58;
            }
        }
    }

    private void calcGroup059_060_063(int i) {
        if (!this.fragment[i].equals("SssO") && !this.fragment[i].equals("SaaO")) {
            return;
        }
        List<IAtom> ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
        IAtom ca0 = ca.get(0);
        IAtom ca1 = ca.get(1);
        if (this.fragment[i].equals("SssO")) {
            if (ca0.getFlag(32) || ca1.getFlag(32)) {
                this.frags[60] = this.frags[60] + 1;
                this.alogpfrag[i] = 60;
            } else {
                for (int j = 0; j <= ca.size() - 1; ++j) {
                    List<IAtom> ca2 = this.atomContainer.getConnectedAtomsList(ca.get(j));
                    for (int k = 0; k <= ca2.size() - 1; ++k) {
                        if (this.atomContainer.getBond(ca.get(j), ca2.get(k)).getOrder() != IBond.Order.DOUBLE || ca2.get(k).getSymbol().equals("C")) continue;
                        this.frags[60] = this.frags[60] + 1;
                        this.alogpfrag[i] = 60;
                        return;
                    }
                }
                if (ca0.getSymbol().equals("O") || ca1.getSymbol().equals("O")) {
                    this.frags[63] = this.frags[63] + 1;
                    this.alogpfrag[i] = 63;
                } else {
                    this.frags[59] = this.frags[59] + 1;
                    this.alogpfrag[i] = 59;
                }
            }
        } else if (this.fragment[i].equals("SaaO")) {
            this.frags[60] = this.frags[60] + 1;
            this.alogpfrag[i] = 60;
        }
    }

    private void calcGroup066_to_079(int i) {
        int j;
        int NAr = 0;
        int NAl = 0;
        IAtom ai = this.atomContainer.getAtom(i);
        if (!ai.getSymbol().equals("N")) {
            return;
        }
        List<IAtom> ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
        for (j = 0; j <= ca.size() - 1; ++j) {
            if (ca.get(j).getSymbol().equals("H")) continue;
            if (ca.get(j).getFlag(32)) {
                ++NAr;
                continue;
            }
            ++NAl;
        }
        for (j = 0; j <= ca.size() - 1; ++j) {
            if (ca.get(j).getSymbol().equals("H")) continue;
            List<IAtom> ca2 = this.atomContainer.getConnectedAtomsList(ca.get(j));
            for (int k = 0; k <= ca2.size() - 1; ++k) {
                IAtom ca2k = ca2.get(k);
                if (this.atomContainer.getAtomNumber(ca2k) == i || ca2k.getSymbol().equals("C") || ca2k.getFlag(32) || ca.get(j).getFlag(32) || ai.getFlag(32) || this.atomContainer.getBond(ca.get(j), ca2k).getOrder() != IBond.Order.DOUBLE) continue;
                this.frags[72] = this.frags[72] + 1;
                this.alogpfrag[i] = 72;
                return;
            }
        }
        if (this.fragment[i].equals("SsNH2")) {
            IChemObject ca0 = null;
            for (int j2 = 0; j2 <= ca.size() - 1; ++j2) {
                if (ca.get(j2).getSymbol().equals("H")) continue;
                ca0 = ca.get(j2);
                break;
            }
            if (ca0.getFlag(32) || !ca0.getSymbol().equals("C")) {
                this.frags[69] = this.frags[69] + 1;
                this.alogpfrag[i] = 69;
            } else {
                this.frags[66] = this.frags[66] + 1;
                this.alogpfrag[i] = 66;
            }
            this.frags[50] = this.frags[50] + 2;
        } else if (this.fragment[i].equals("SaaNH") || this.fragment[i].equals("SsaaN")) {
            this.frags[73] = this.frags[73] + 1;
            this.alogpfrag[i] = 73;
            if (this.fragment[i].equals("SaaNH")) {
                this.frags[50] = this.frags[50] + 1;
            }
        } else if (this.fragment[i].equals("SssNH")) {
            if (NAr == 2 && NAl == 0) {
                this.frags[73] = this.frags[73] + 1;
                this.alogpfrag[i] = 73;
            } else if (NAr == 1 && NAl == 1) {
                this.frags[70] = this.frags[70] + 1;
                this.alogpfrag[i] = 70;
            } else if (NAr == 0 && NAl == 2) {
                this.frags[67] = this.frags[67] + 1;
                this.alogpfrag[i] = 67;
            }
            this.frags[50] = this.frags[50] + 1;
        } else if (this.fragment[i].equals("SsssN")) {
            if (NAr == 3 && NAl == 0 || NAr == 2 && NAl == 1) {
                this.frags[73] = this.frags[73] + 1;
                this.alogpfrag[i] = 73;
            } else if (NAr == 1 && NAl == 2) {
                this.frags[71] = this.frags[71] + 1;
                this.alogpfrag[i] = 71;
            } else if (NAr == 0 && NAl == 3) {
                this.frags[68] = this.frags[68] + 1;
                this.alogpfrag[i] = 68;
            }
        } else if (this.fragment[i].equals("SaaN")) {
            this.frags[75] = this.frags[75] + 1;
            this.alogpfrag[i] = 75;
        } else if (this.fragment[i].equals("SssdNp")) {
            boolean HaveSsOm = false;
            boolean HaveSdO = false;
            boolean Ar = false;
            for (int j3 = 0; j3 <= ca.size() - 1; ++j3) {
                if (this.fragment[this.atomContainer.getAtomNumber(ca.get(j3))].equals("SsOm")) {
                    HaveSsOm = true;
                    continue;
                }
                if (this.fragment[this.atomContainer.getAtomNumber(ca.get(j3))].equals("SdO")) {
                    HaveSdO = true;
                    continue;
                }
                if (!ca.get(j3).getFlag(32)) continue;
                Ar = true;
            }
            if (HaveSsOm && HaveSdO && Ar) {
                this.frags[76] = this.frags[76] + 1;
                this.alogpfrag[i] = 76;
            } else if (HaveSsOm && HaveSdO && !Ar) {
                this.frags[77] = this.frags[77] + 1;
                this.alogpfrag[i] = 77;
            } else {
                this.frags[79] = this.frags[79] + 1;
                this.alogpfrag[i] = 79;
            }
        } else if (this.fragment[i].equals("StN")) {
            IAtom ca0 = ca.get(0);
            if (ca0.getSymbol().equals("C")) {
                this.frags[74] = this.frags[74] + 1;
                this.alogpfrag[i] = 74;
            }
        } else if (this.fragment[i].equals("SdNH") || this.fragment[i].equals("SdsN")) {
            if (this.fragment[i].equals("SdsN")) {
                IAtom ca0 = ca.get(0);
                IAtom ca1 = ca.get(1);
                if (ca0.getSymbol().equals("O") && ca1.getSymbol().equals("O")) {
                    this.frags[76] = this.frags[76] + 1;
                    this.alogpfrag[i] = 76;
                    return;
                }
            }
            boolean flag1 = false;
            boolean flag2 = false;
            for (int j4 = 0; j4 <= ca.size() - 1; ++j4) {
                if (ca.get(j4).getSymbol().equals("H")) continue;
                if (this.atomContainer.getBond(ai, ca.get(j4)).getOrder() == IBond.Order.DOUBLE) {
                    if (ca.get(j4).getSymbol().equals("C")) {
                        this.frags[74] = this.frags[74] + 1;
                        this.alogpfrag[i] = 74;
                        return;
                    }
                    flag1 = true;
                } else if (!ca.get(j4).getSymbol().equals("C") || ca.get(j4).getFlag(32)) {
                    flag2 = true;
                }
                if (!flag1 || !flag2) continue;
                this.frags[78] = this.frags[78] + 1;
                this.alogpfrag[i] = 78;
            }
            if (this.fragment[i].equals("SdNH")) {
                this.frags[50] = this.frags[50] + 1;
            }
        } else if (this.fragment[i].indexOf("p") > -1) {
            this.frags[79] = this.frags[79] + 1;
            this.alogpfrag[i] = 79;
        }
    }

    private void calcGroup081_to_085(int i) {
        if (!this.fragment[i].equals("SsF")) {
            return;
        }
        List<IAtom> ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
        IAtom ca0 = ca.get(0);
        List<IBond> bonds = this.atomContainer.getConnectedBondsList(ca0);
        int doublebondcount = 0;
        int triplebondcount = 0;
        String hybrid = "";
        for (int j = 0; j <= bonds.size() - 1; ++j) {
            IBond bj = bonds.get(j);
            if (bj.getOrder() == IBond.Order.DOUBLE) {
                ++doublebondcount;
                continue;
            }
            if (bj.getOrder() != IBond.Order.TRIPLE) continue;
            ++triplebondcount;
        }
        if (doublebondcount == 0 && triplebondcount == 0) {
            hybrid = "sp3";
        } else if (doublebondcount == 1) {
            hybrid = "sp2";
        } else if (doublebondcount == 2 || triplebondcount == 1) {
            hybrid = "sp";
        }
        List<IAtom> ca2 = this.atomContainer.getConnectedAtomsList(ca0);
        int OxNum = 0;
        for (int j = 0; j <= ca2.size() - 1; ++j) {
            IAtom ca2j = ca2.get(j);
            String s = ca2j.getSymbol();
            if (!(this.ap.getNormalizedElectronegativity(ca2j.getSymbol()) > 1.0)) continue;
            OxNum = (int)((double)OxNum + BondManipulator.destroyBondOrder(this.atomContainer.getBond(ca0, ca2j).getOrder()));
        }
        if (hybrid.equals("sp3") && OxNum == 1) {
            this.frags[81] = this.frags[81] + 1;
            this.alogpfrag[i] = 81;
        } else if (hybrid.equals("sp3") && OxNum == 2) {
            this.frags[82] = this.frags[82] + 1;
            this.alogpfrag[i] = 82;
        } else if (hybrid.equals("sp3") && OxNum == 3) {
            this.frags[83] = this.frags[83] + 1;
            this.alogpfrag[i] = 83;
        } else if (hybrid.equals("sp2") && OxNum == 1) {
            this.frags[84] = this.frags[84] + 1;
            this.alogpfrag[i] = 84;
        } else if (hybrid.equals("sp2") && OxNum > 1 || hybrid.equals("sp") && OxNum >= 1 || hybrid.equals("sp3") && OxNum == 4 || !ca0.getSymbol().equals("C")) {
            this.frags[85] = this.frags[85] + 1;
            this.alogpfrag[i] = 85;
        }
    }

    private void calcGroup086_to_090(int i) {
        if (!this.fragment[i].equals("SsCl")) {
            return;
        }
        List<IAtom> ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
        IAtom ca0 = ca.get(0);
        List<IBond> bonds = this.atomContainer.getConnectedBondsList(ca0);
        int doublebondcount = 0;
        int triplebondcount = 0;
        String hybrid = "";
        for (int j = 0; j <= bonds.size() - 1; ++j) {
            IBond bj = bonds.get(j);
            if (bj.getOrder() == IBond.Order.DOUBLE) {
                ++doublebondcount;
                continue;
            }
            if (bj.getOrder() != IBond.Order.TRIPLE) continue;
            ++triplebondcount;
        }
        if (doublebondcount == 0 && triplebondcount == 0) {
            hybrid = "sp3";
        } else if (doublebondcount == 1) {
            hybrid = "sp2";
        } else if (doublebondcount == 2 || triplebondcount == 1) {
            hybrid = "sp";
        }
        List<IAtom> ca2 = this.atomContainer.getConnectedAtomsList(ca0);
        int OxNum = 0;
        for (int j = 0; j <= ca2.size() - 1; ++j) {
            IAtom ca2j = ca2.get(j);
            String s = ca2j.getSymbol();
            if (!(this.ap.getNormalizedElectronegativity(s) > 1.0)) continue;
            OxNum = (int)((double)OxNum + BondManipulator.destroyBondOrder(this.atomContainer.getBond(ca0, ca2j).getOrder()));
        }
        if (hybrid.equals("sp3") && OxNum == 1) {
            this.frags[86] = this.frags[86] + 1;
            this.alogpfrag[i] = 86;
        } else if (hybrid.equals("sp3") && OxNum == 2) {
            this.frags[87] = this.frags[87] + 1;
            this.alogpfrag[i] = 87;
        } else if (hybrid.equals("sp3") && OxNum == 3) {
            this.frags[88] = this.frags[88] + 1;
            this.alogpfrag[i] = 88;
        } else if (hybrid.equals("sp2") && OxNum == 1) {
            this.frags[89] = this.frags[89] + 1;
            this.alogpfrag[i] = 89;
        } else if (hybrid.equals("sp2") && OxNum > 1 || hybrid.equals("sp") && OxNum >= 1 || hybrid.equals("sp3") && OxNum == 4 || !ca0.getSymbol().equals("C")) {
            this.frags[90] = this.frags[90] + 1;
            this.alogpfrag[i] = 90;
        }
    }

    private void calcGroup091_to_095(int i) {
        if (!this.fragment[i].equals("SsBr")) {
            return;
        }
        List<IAtom> ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
        IAtom ca0 = ca.get(0);
        List<IBond> bonds = this.atomContainer.getConnectedBondsList(ca0);
        int doublebondcount = 0;
        int triplebondcount = 0;
        String hybrid = "";
        for (int j = 0; j <= bonds.size() - 1; ++j) {
            IBond bj = bonds.get(j);
            if (bj.getOrder() == IBond.Order.DOUBLE) {
                ++doublebondcount;
            }
            if (bj.getOrder() != IBond.Order.TRIPLE) continue;
            ++triplebondcount;
        }
        if (doublebondcount == 0 && triplebondcount == 0) {
            hybrid = "sp3";
        } else if (doublebondcount == 1) {
            hybrid = "sp2";
        } else if (doublebondcount == 2 || triplebondcount == 1) {
            hybrid = "sp";
        }
        List<IAtom> ca2 = this.atomContainer.getConnectedAtomsList(ca0);
        int OxNum = 0;
        for (int j = 0; j <= ca2.size() - 1; ++j) {
            IAtom ca2j = ca2.get(j);
            String s = ca2j.getSymbol();
            if (!(this.ap.getNormalizedElectronegativity(ca2j.getSymbol()) > 1.0)) continue;
            OxNum = (int)((double)OxNum + BondManipulator.destroyBondOrder(this.atomContainer.getBond(ca0, ca2j).getOrder()));
        }
        if (hybrid.equals("sp3") && OxNum == 1) {
            this.frags[91] = this.frags[91] + 1;
            this.alogpfrag[i] = 91;
        } else if (hybrid.equals("sp3") && OxNum == 2) {
            this.frags[92] = this.frags[92] + 1;
            this.alogpfrag[i] = 92;
        } else if (hybrid.equals("sp3") && OxNum == 3) {
            this.frags[93] = this.frags[93] + 1;
            this.alogpfrag[i] = 93;
        } else if (hybrid.equals("sp2") && OxNum == 1) {
            this.frags[94] = this.frags[94] + 1;
            this.alogpfrag[i] = 94;
        } else if (hybrid.equals("sp2") && OxNum > 1 || hybrid.equals("sp") && OxNum >= 1 || hybrid.equals("sp3") && OxNum == 4 || !ca0.getSymbol().equals("C")) {
            this.frags[95] = this.frags[95] + 1;
            this.alogpfrag[i] = 95;
        }
    }

    private void calcGroup096_to_100(int i) {
        if (!this.fragment[i].equals("SsI")) {
            return;
        }
        List<IAtom> ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
        IAtom ca0 = ca.get(0);
        List<IBond> bonds = this.atomContainer.getConnectedBondsList(ca0);
        int doublebondcount = 0;
        int triplebondcount = 0;
        String hybrid = "";
        for (int j = 0; j <= bonds.size() - 1; ++j) {
            IBond bj = bonds.get(j);
            if (bj.getOrder() == IBond.Order.DOUBLE) {
                ++doublebondcount;
                continue;
            }
            if (bj.getOrder() != IBond.Order.TRIPLE) continue;
            ++triplebondcount;
        }
        if (doublebondcount == 0 && triplebondcount == 0) {
            hybrid = "sp3";
        } else if (doublebondcount == 1) {
            hybrid = "sp2";
        } else if (doublebondcount == 2 || triplebondcount == 1) {
            hybrid = "sp";
        }
        List<IAtom> ca2 = this.atomContainer.getConnectedAtomsList(ca0);
        int OxNum = 0;
        for (int j = 0; j <= ca2.size() - 1; ++j) {
            IAtom ca2j = ca2.get(j);
            String s = ca2j.getSymbol();
            if (!(this.ap.getNormalizedElectronegativity(ca2j.getSymbol()) > 1.0)) continue;
            OxNum = (int)((double)OxNum + BondManipulator.destroyBondOrder(this.atomContainer.getBond(ca0, ca2j).getOrder()));
        }
        if (hybrid.equals("sp3") && OxNum == 1) {
            this.frags[96] = this.frags[96] + 1;
            this.alogpfrag[i] = 96;
        } else if (hybrid.equals("sp3") && OxNum == 2) {
            this.frags[97] = this.frags[97] + 1;
            this.alogpfrag[i] = 97;
        } else if (hybrid.equals("sp3") && OxNum == 3) {
            this.frags[98] = this.frags[98] + 1;
            this.alogpfrag[i] = 98;
        } else if (hybrid.equals("sp2") && OxNum == 1) {
            this.frags[99] = this.frags[99] + 1;
            this.alogpfrag[i] = 99;
        } else if (hybrid.equals("sp2") && OxNum > 1 || hybrid.equals("sp") && OxNum >= 1 || hybrid.equals("sp3") && OxNum == 4 || !ca0.getSymbol().equals("C")) {
            this.frags[100] = this.frags[100] + 1;
            this.alogpfrag[i] = 100;
        }
    }

    private void calcGroup101_to_104(int i) {
        IAtom ai = this.atomContainer.getAtom(i);
        String s = ai.getSymbol();
        if (ai.getFormalCharge() == -1) {
            if (s.equals("F")) {
                this.frags[101] = this.frags[101] + 1;
                this.alogpfrag[i] = 101;
            } else if (s.equals("Cl")) {
                this.frags[102] = this.frags[102] + 1;
                this.alogpfrag[i] = 102;
            } else if (s.equals("Br")) {
                this.frags[103] = this.frags[103] + 1;
                this.alogpfrag[i] = 103;
            } else if (s.equals("I")) {
                this.frags[104] = this.frags[104] + 1;
                this.alogpfrag[i] = 104;
            }
        }
    }

    private void calcGroup106(int i) {
        if (this.fragment[i].equals("SsSH")) {
            this.frags[106] = this.frags[106] + 1;
            this.alogpfrag[i] = 106;
            this.frags[50] = this.frags[50] + 1;
        }
    }

    private void calcGroup107(int i) {
        if (this.fragment[i].equals("SssS") || this.fragment[i].equals("SaaS")) {
            this.frags[107] = this.frags[107] + 1;
            this.alogpfrag[i] = 107;
        }
    }

    private void calcGroup108(int i) {
        if (this.fragment[i].equals("SdS")) {
            this.frags[108] = this.frags[108] + 1;
            this.alogpfrag[i] = 108;
        }
    }

    private void calcGroup109(int i) {
        if (!this.fragment[i].equals("SdssS")) {
            return;
        }
        List<IAtom> ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
        IAtom ai = this.atomContainer.getAtom(i);
        int SdOCount = 0;
        int SsCCount = 0;
        for (int j = 0; j <= ca.size() - 1; ++j) {
            if (this.atomContainer.getBond(ai, ca.get(j)).getOrder() == IBond.Order.SINGLE) {
                if (!ca.get(j).getSymbol().equals("C")) continue;
                ++SsCCount;
                continue;
            }
            if (this.atomContainer.getBond(ai, ca.get(j)).getOrder() != IBond.Order.DOUBLE || !ca.get(j).getSymbol().equals("O")) continue;
            ++SdOCount;
        }
        if (SdOCount == 1) {
            this.frags[109] = this.frags[109] + 1;
            this.alogpfrag[i] = 109;
        }
    }

    private void calcGroup110(int i) {
        if (!this.fragment[i].equals("SddssS")) {
            return;
        }
        List<IAtom> ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
        IAtom ai = this.atomContainer.getAtom(i);
        int SdOCount = 0;
        int SsCCount = 0;
        for (int j = 0; j <= ca.size() - 1; ++j) {
            if (this.atomContainer.getBond(ai, ca.get(j)).getOrder() == IBond.Order.SINGLE) {
                if (!ca.get(j).getSymbol().equals("C")) continue;
                ++SsCCount;
                continue;
            }
            if (this.atomContainer.getBond(ai, ca.get(j)).getOrder() != IBond.Order.DOUBLE || !ca.get(j).getSymbol().equals("O")) continue;
            ++SdOCount;
        }
        if (SdOCount == 2) {
            this.frags[110] = this.frags[110] + 1;
            this.alogpfrag[i] = 110;
        }
    }

    private void calcGroup111(int i) {
        if (this.fragment[i].equals("SssssSi")) {
            this.frags[111] = this.frags[111] + 1;
            this.alogpfrag[i] = 111;
        }
    }

    private void calcGroup116_117_120(int i) {
        List<IAtom> ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
        IAtom ai = this.atomContainer.getAtom(i);
        int XCount = 0;
        int RCount = 0;
        boolean PdX = false;
        if (!this.fragment[i].equals("SdsssP")) {
            return;
        }
        for (int j = 0; j <= ca.size() - 1; ++j) {
            if (this.atomContainer.getBond(ai, ca.get(j)).getOrder() == IBond.Order.SINGLE) {
                if (ca.get(j).getSymbol().equals("C")) {
                    ++RCount;
                    continue;
                }
                ++XCount;
                continue;
            }
            if (this.atomContainer.getBond(ai, ca.get(j)).getOrder() != IBond.Order.DOUBLE || ca.get(j).getSymbol().equals("C")) continue;
            PdX = true;
        }
        if (PdX) {
            if (RCount == 3) {
                this.frags[116] = this.frags[116] + 1;
                this.alogpfrag[i] = 116;
            } else if (XCount == 3) {
                this.frags[117] = this.frags[117] + 1;
                this.alogpfrag[i] = 117;
            } else if (XCount == 2 && RCount == 1) {
                this.frags[120] = this.frags[120] + 1;
                this.alogpfrag[i] = 120;
            }
        }
    }

    private void calcGroup118_119(int i) {
        if (!this.fragment[i].equals("SsssP")) {
            return;
        }
        List<IAtom> ca = this.atomContainer.getConnectedAtomsList(this.atomContainer.getAtom(i));
        IAtom ai = this.atomContainer.getAtom(i);
        int XCount = 0;
        int RCount = 0;
        for (int j = 0; j <= ca.size() - 1; ++j) {
            if (this.atomContainer.getBond(ai, ca.get(j)).getOrder() != IBond.Order.SINGLE) continue;
            if (ca.get(j).getSymbol().equals("C")) {
                ++RCount;
                continue;
            }
            ++XCount;
        }
        if (XCount == 3) {
            this.frags[118] = this.frags[118] + 1;
            this.alogpfrag[i] = 118;
        } else if (RCount == 3) {
            this.frags[119] = this.frags[119] + 1;
            this.alogpfrag[i] = 119;
        }
    }

    private boolean inSameAromaticRing(IAtomContainer atomContainer, IAtom atom1, IAtom atom2, IRingSet rs) {
        boolean SameRing = false;
        for (int i = 0; i <= rs.getAtomContainerCount() - 1; ++i) {
            IRing r = (IRing)rs.getAtomContainer(i);
            if (!r.getFlag(32)) continue;
            boolean HaveOne = false;
            boolean HaveTwo = false;
            for (int j = 0; j <= r.getAtomCount() - 1; ++j) {
                if (atomContainer.getAtomNumber(r.getAtom(j)) == atomContainer.getAtomNumber(atom1)) {
                    HaveOne = true;
                }
                if (atomContainer.getAtomNumber(r.getAtom(j)) != atomContainer.getAtomNumber(atom2)) continue;
                HaveTwo = true;
            }
            if (!HaveOne || !HaveTwo) continue;
            SameRing = true;
            return SameRing;
        }
        return SameRing;
    }

    @TestMethod(value="testCalculate_IAtomContainer,testChloroButane")
    public DescriptorValue calculate(IAtomContainer atomContainer) {
        IRingSet rs;
        IAtomContainer container;
        try {
            container = atomContainer.clone();
            AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(container);
            CDKHydrogenAdder hAdder = CDKHydrogenAdder.getInstance(container.getBuilder());
            hAdder.addImplicitHydrogens(container);
            AtomContainerManipulator.convertImplicitToExplicitHydrogens(container);
        }
        catch (CloneNotSupportedException e) {
            return this.getDummyDescriptorValue(new CDKException("Error during clone"));
        }
        catch (CDKException e) {
            return this.getDummyDescriptorValue(new CDKException("Error during atom typing" + e.getMessage()));
        }
        try {
            AllRingsFinder arf = new AllRingsFinder();
            rs = arf.findAllRings(container);
        }
        catch (Exception e) {
            return this.getDummyDescriptorValue(new CDKException("Could not find all rings: " + e.getMessage()));
        }
        String[] fragment = new String[container.getAtomCount()];
        EStateAtomTypeMatcher eStateMatcher = new EStateAtomTypeMatcher();
        eStateMatcher.setRingSet(rs);
        for (int i = 0; i < container.getAtomCount(); ++i) {
            IAtomType atomType = eStateMatcher.findMatchingAtomType(container, container.getAtom(i));
            fragment[i] = atomType == null ? null : atomType.getAtomTypeName();
        }
        double[] ret = new double[]{};
        try {
            ret = this.calculate(container, fragment, rs);
        }
        catch (CDKException e) {
            return this.getDummyDescriptorValue(new CDKException(e.getMessage()));
        }
        DoubleArrayResult results = new DoubleArrayResult();
        results.add(ret[0]);
        results.add(ret[1]);
        results.add(ret[2]);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), results, this.getDescriptorNames());
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        DoubleArrayResult results = new DoubleArrayResult();
        results.add(Double.NaN);
        results.add(Double.NaN);
        results.add(Double.NaN);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), results, this.getDescriptorNames(), e);
    }

    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(3);
    }

    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#ALOGP", this.getClass().getName(), "$Id: 6983492b91dd23cba8e3108ed2118fee300fb40b $", "The Chemistry Development Kit");
    }

    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return new String[0];
    }

    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return null;
    }

    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
    }

    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return strings;
    }

    static {
        ALOGPDescriptor.fragval[1] = -1.5603;
        ALOGPDescriptor.fragval[2] = -1.012;
        ALOGPDescriptor.fragval[3] = -0.6681;
        ALOGPDescriptor.fragval[4] = -0.3698;
        ALOGPDescriptor.fragval[5] = -1.788;
        ALOGPDescriptor.fragval[6] = -1.2486;
        ALOGPDescriptor.fragval[7] = -1.0305;
        ALOGPDescriptor.fragval[8] = -0.6805;
        ALOGPDescriptor.fragval[9] = -0.3858;
        ALOGPDescriptor.fragval[10] = 0.7555;
        ALOGPDescriptor.fragval[11] = -0.2849;
        ALOGPDescriptor.fragval[12] = 0.02;
        ALOGPDescriptor.fragval[13] = 0.7894;
        ALOGPDescriptor.fragval[14] = 1.6422;
        ALOGPDescriptor.fragval[15] = -0.7866;
        ALOGPDescriptor.fragval[16] = -0.3962;
        ALOGPDescriptor.fragval[17] = 0.0383;
        ALOGPDescriptor.fragval[18] = -0.8051;
        ALOGPDescriptor.fragval[19] = -0.2129;
        ALOGPDescriptor.fragval[20] = 0.2432;
        ALOGPDescriptor.fragval[21] = 0.4697;
        ALOGPDescriptor.fragval[22] = 0.2952;
        ALOGPDescriptor.fragval[23] = 0.0;
        ALOGPDescriptor.fragval[24] = -0.3251;
        ALOGPDescriptor.fragval[25] = 0.1492;
        ALOGPDescriptor.fragval[26] = 0.1539;
        ALOGPDescriptor.fragval[27] = 5.0E-4;
        ALOGPDescriptor.fragval[28] = 0.2361;
        ALOGPDescriptor.fragval[29] = 0.3514;
        ALOGPDescriptor.fragval[30] = 0.1814;
        ALOGPDescriptor.fragval[31] = 0.0901;
        ALOGPDescriptor.fragval[32] = 0.5142;
        ALOGPDescriptor.fragval[33] = -0.3723;
        ALOGPDescriptor.fragval[34] = 0.2813;
        ALOGPDescriptor.fragval[35] = 0.1191;
        ALOGPDescriptor.fragval[36] = -0.132;
        ALOGPDescriptor.fragval[37] = -0.0244;
        ALOGPDescriptor.fragval[38] = -0.2405;
        ALOGPDescriptor.fragval[39] = -0.0909;
        ALOGPDescriptor.fragval[40] = -0.1002;
        ALOGPDescriptor.fragval[41] = 0.4182;
        ALOGPDescriptor.fragval[42] = -0.2147;
        ALOGPDescriptor.fragval[43] = -9.0E-4;
        ALOGPDescriptor.fragval[44] = 0.1388;
        ALOGPDescriptor.fragval[45] = 0.0;
        ALOGPDescriptor.fragval[46] = 0.7341;
        ALOGPDescriptor.fragval[47] = 0.6301;
        ALOGPDescriptor.fragval[48] = 0.518;
        ALOGPDescriptor.fragval[49] = -0.0371;
        ALOGPDescriptor.fragval[50] = -0.1036;
        ALOGPDescriptor.fragval[51] = 0.5234;
        ALOGPDescriptor.fragval[52] = 0.6666;
        ALOGPDescriptor.fragval[53] = 0.5372;
        ALOGPDescriptor.fragval[54] = 0.6338;
        ALOGPDescriptor.fragval[55] = 0.362;
        ALOGPDescriptor.fragval[56] = -0.3567;
        ALOGPDescriptor.fragval[57] = -0.0127;
        ALOGPDescriptor.fragval[58] = -0.0233;
        ALOGPDescriptor.fragval[59] = -0.1541;
        ALOGPDescriptor.fragval[60] = 0.0324;
        ALOGPDescriptor.fragval[61] = 1.052;
        ALOGPDescriptor.fragval[62] = -0.7941;
        ALOGPDescriptor.fragval[63] = 0.4165;
        ALOGPDescriptor.fragval[64] = 0.6601;
        ALOGPDescriptor.fragval[65] = 0.0;
        ALOGPDescriptor.fragval[66] = -0.5427;
        ALOGPDescriptor.fragval[67] = -0.3168;
        ALOGPDescriptor.fragval[68] = 0.0132;
        ALOGPDescriptor.fragval[69] = -0.3883;
        ALOGPDescriptor.fragval[70] = -0.0389;
        ALOGPDescriptor.fragval[71] = 0.1087;
        ALOGPDescriptor.fragval[72] = -0.5113;
        ALOGPDescriptor.fragval[73] = 0.1259;
        ALOGPDescriptor.fragval[74] = 0.1349;
        ALOGPDescriptor.fragval[75] = -0.1624;
        ALOGPDescriptor.fragval[76] = -2.0585;
        ALOGPDescriptor.fragval[77] = -1.915;
        ALOGPDescriptor.fragval[78] = 0.4208;
        ALOGPDescriptor.fragval[79] = -1.4439;
        ALOGPDescriptor.fragval[80] = 0.0;
        ALOGPDescriptor.fragval[81] = 0.4797;
        ALOGPDescriptor.fragval[82] = 0.2358;
        ALOGPDescriptor.fragval[83] = 0.1029;
        ALOGPDescriptor.fragval[84] = 0.3566;
        ALOGPDescriptor.fragval[85] = 0.1988;
        ALOGPDescriptor.fragval[86] = 0.7443;
        ALOGPDescriptor.fragval[87] = 0.5337;
        ALOGPDescriptor.fragval[88] = 0.2996;
        ALOGPDescriptor.fragval[89] = 0.8155;
        ALOGPDescriptor.fragval[90] = 0.4856;
        ALOGPDescriptor.fragval[91] = 0.8888;
        ALOGPDescriptor.fragval[92] = 0.7452;
        ALOGPDescriptor.fragval[93] = 0.5034;
        ALOGPDescriptor.fragval[94] = 0.8995;
        ALOGPDescriptor.fragval[95] = 0.5946;
        ALOGPDescriptor.fragval[96] = 1.4201;
        ALOGPDescriptor.fragval[97] = 1.1472;
        ALOGPDescriptor.fragval[98] = 0.0;
        ALOGPDescriptor.fragval[99] = 0.7293;
        ALOGPDescriptor.fragval[100] = 0.7173;
        ALOGPDescriptor.fragval[101] = 0.0;
        ALOGPDescriptor.fragval[102] = -2.6737;
        ALOGPDescriptor.fragval[103] = -2.4178;
        ALOGPDescriptor.fragval[104] = -3.1121;
        ALOGPDescriptor.fragval[105] = 0.0;
        ALOGPDescriptor.fragval[106] = 0.6146;
        ALOGPDescriptor.fragval[107] = 0.5906;
        ALOGPDescriptor.fragval[108] = 0.8758;
        ALOGPDescriptor.fragval[109] = -0.4979;
        ALOGPDescriptor.fragval[110] = -0.3786;
        ALOGPDescriptor.fragval[111] = 1.5188;
        ALOGPDescriptor.fragval[112] = 1.0255;
        ALOGPDescriptor.fragval[113] = 0.0;
        ALOGPDescriptor.fragval[114] = 0.0;
        ALOGPDescriptor.fragval[115] = 0.0;
        ALOGPDescriptor.fragval[116] = -0.9359;
        ALOGPDescriptor.fragval[117] = -0.1726;
        ALOGPDescriptor.fragval[118] = -0.7966;
        ALOGPDescriptor.fragval[119] = 0.6705;
        ALOGPDescriptor.fragval[120] = -0.4801;
        refracval = new double[121];
        ALOGPDescriptor.refracval[1] = 2.968;
        ALOGPDescriptor.refracval[2] = 2.9116;
        ALOGPDescriptor.refracval[3] = 2.8028;
        ALOGPDescriptor.refracval[4] = 2.6205;
        ALOGPDescriptor.refracval[5] = 3.015;
        ALOGPDescriptor.refracval[6] = 2.9244;
        ALOGPDescriptor.refracval[7] = 2.6329;
        ALOGPDescriptor.refracval[8] = 2.504;
        ALOGPDescriptor.refracval[9] = 2.377;
        ALOGPDescriptor.refracval[10] = 2.5559;
        ALOGPDescriptor.refracval[11] = 2.303;
        ALOGPDescriptor.refracval[12] = 2.3006;
        ALOGPDescriptor.refracval[13] = 2.9627;
        ALOGPDescriptor.refracval[14] = 2.3038;
        ALOGPDescriptor.refracval[15] = 3.2001;
        ALOGPDescriptor.refracval[16] = 4.2654;
        ALOGPDescriptor.refracval[17] = 3.9392;
        ALOGPDescriptor.refracval[18] = 3.6005;
        ALOGPDescriptor.refracval[19] = 4.487;
        ALOGPDescriptor.refracval[20] = 3.2001;
        ALOGPDescriptor.refracval[21] = 3.4825;
        ALOGPDescriptor.refracval[22] = 4.2817;
        ALOGPDescriptor.refracval[23] = 3.9556;
        ALOGPDescriptor.refracval[24] = 3.4491;
        ALOGPDescriptor.refracval[25] = 3.8821;
        ALOGPDescriptor.refracval[26] = 3.7593;
        ALOGPDescriptor.refracval[27] = 2.5009;
        ALOGPDescriptor.refracval[28] = 2.5;
        ALOGPDescriptor.refracval[29] = 3.0627;
        ALOGPDescriptor.refracval[30] = 2.5009;
        ALOGPDescriptor.refracval[31] = 0.0;
        ALOGPDescriptor.refracval[32] = 2.6632;
        ALOGPDescriptor.refracval[33] = 3.4671;
        ALOGPDescriptor.refracval[34] = 3.6842;
        ALOGPDescriptor.refracval[35] = 2.9372;
        ALOGPDescriptor.refracval[36] = 4.019;
        ALOGPDescriptor.refracval[37] = 4.777;
        ALOGPDescriptor.refracval[38] = 3.9031;
        ALOGPDescriptor.refracval[39] = 3.9964;
        ALOGPDescriptor.refracval[40] = 3.4986;
        ALOGPDescriptor.refracval[41] = 3.4997;
        ALOGPDescriptor.refracval[42] = 2.7784;
        ALOGPDescriptor.refracval[43] = 2.6267;
        ALOGPDescriptor.refracval[44] = 2.5;
        ALOGPDescriptor.refracval[45] = 0.0;
        ALOGPDescriptor.refracval[46] = 0.8447;
        ALOGPDescriptor.refracval[47] = 0.8939;
        ALOGPDescriptor.refracval[48] = 0.8005;
        ALOGPDescriptor.refracval[49] = 0.832;
        ALOGPDescriptor.refracval[50] = 0.8;
        ALOGPDescriptor.refracval[51] = 0.8188;
        ALOGPDescriptor.refracval[52] = 0.9215;
        ALOGPDescriptor.refracval[53] = 0.9769;
        ALOGPDescriptor.refracval[54] = 0.7701;
        ALOGPDescriptor.refracval[55] = 0.0;
        ALOGPDescriptor.refracval[56] = 1.7646;
        ALOGPDescriptor.refracval[57] = 1.4778;
        ALOGPDescriptor.refracval[58] = 1.4429;
        ALOGPDescriptor.refracval[59] = 1.6191;
        ALOGPDescriptor.refracval[60] = 1.3502;
        ALOGPDescriptor.refracval[61] = 1.945;
        ALOGPDescriptor.refracval[62] = 0.0;
        ALOGPDescriptor.refracval[63] = 0.0;
        ALOGPDescriptor.refracval[64] = 11.1366;
        ALOGPDescriptor.refracval[65] = 13.1149;
        ALOGPDescriptor.refracval[66] = 2.6221;
        ALOGPDescriptor.refracval[67] = 2.5;
        ALOGPDescriptor.refracval[68] = 2.898;
        ALOGPDescriptor.refracval[69] = 3.6841;
        ALOGPDescriptor.refracval[70] = 4.2808;
        ALOGPDescriptor.refracval[71] = 3.6189;
        ALOGPDescriptor.refracval[72] = 2.5;
        ALOGPDescriptor.refracval[73] = 2.7956;
        ALOGPDescriptor.refracval[74] = 2.7;
        ALOGPDescriptor.refracval[75] = 4.2063;
        ALOGPDescriptor.refracval[76] = 4.0184;
        ALOGPDescriptor.refracval[77] = 3.0009;
        ALOGPDescriptor.refracval[78] = 4.7142;
        ALOGPDescriptor.refracval[79] = 0.0;
        ALOGPDescriptor.refracval[80] = 0.0;
        ALOGPDescriptor.refracval[81] = 0.8725;
        ALOGPDescriptor.refracval[82] = 1.1837;
        ALOGPDescriptor.refracval[83] = 1.1573;
        ALOGPDescriptor.refracval[84] = 0.8001;
        ALOGPDescriptor.refracval[85] = 1.5013;
        ALOGPDescriptor.refracval[86] = 5.6156;
        ALOGPDescriptor.refracval[87] = 6.1022;
        ALOGPDescriptor.refracval[88] = 5.9921;
        ALOGPDescriptor.refracval[89] = 5.3885;
        ALOGPDescriptor.refracval[90] = 6.1363;
        ALOGPDescriptor.refracval[91] = 8.5991;
        ALOGPDescriptor.refracval[92] = 8.9188;
        ALOGPDescriptor.refracval[93] = 8.8006;
        ALOGPDescriptor.refracval[94] = 8.2065;
        ALOGPDescriptor.refracval[95] = 8.7352;
        ALOGPDescriptor.refracval[96] = 13.9462;
        ALOGPDescriptor.refracval[97] = 14.0792;
        ALOGPDescriptor.refracval[98] = 14.073;
        ALOGPDescriptor.refracval[99] = 12.9918;
        ALOGPDescriptor.refracval[100] = 13.3408;
        ALOGPDescriptor.refracval[101] = 0.0;
        ALOGPDescriptor.refracval[102] = 0.0;
        ALOGPDescriptor.refracval[103] = 0.0;
        ALOGPDescriptor.refracval[104] = 0.0;
        ALOGPDescriptor.refracval[105] = 0.0;
        ALOGPDescriptor.refracval[106] = 7.8916;
        ALOGPDescriptor.refracval[107] = 7.7935;
        ALOGPDescriptor.refracval[108] = 9.4338;
        ALOGPDescriptor.refracval[109] = 7.7223;
        ALOGPDescriptor.refracval[110] = 5.7558;
        ALOGPDescriptor.refracval[111] = 0.0;
        ALOGPDescriptor.refracval[112] = 0.0;
        ALOGPDescriptor.refracval[113] = 0.0;
        ALOGPDescriptor.refracval[114] = 0.0;
        ALOGPDescriptor.refracval[115] = 0.0;
        ALOGPDescriptor.refracval[116] = 5.5306;
        ALOGPDescriptor.refracval[117] = 5.5152;
        ALOGPDescriptor.refracval[118] = 6.836;
        ALOGPDescriptor.refracval[119] = 10.0101;
        ALOGPDescriptor.refracval[120] = 5.2806;
        strings = new String[]{"ALogP", "ALogp2", "AMR"};
    }
}

