/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.periodictable;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.tools.periodictable.ElementPTFactory;
import org.openscience.cdk.tools.periodictable.PeriodicTableElement;

@TestClass(value="org.openscience.cdk.tools.periodictable.PeriodicTableTest")
public class PeriodicTable {
    private static volatile boolean isInitialized = false;
    private static volatile Map<String, PeriodicTableElement> elements;
    private static volatile Map<Integer, PeriodicTableElement> elementsByNumber;

    private static synchronized void initialize() {
        ElementPTFactory factory;
        if (isInitialized) {
            return;
        }
        try {
            factory = ElementPTFactory.getInstance();
        }
        catch (IOException e) {
            elements = null;
            return;
        }
        elements = new HashMap<String, PeriodicTableElement>();
        elementsByNumber = new HashMap<Integer, PeriodicTableElement>();
        List<PeriodicTableElement> tmp = factory.getElements();
        for (PeriodicTableElement element : tmp) {
            elements.put(element.getSymbol(), element);
            elementsByNumber.put(element.getAtomicNumber(), element);
        }
        try {
            PeriodicTable.readVDW();
            PeriodicTable.readCovalent();
            PeriodicTable.readPEneg();
        }
        catch (IOException e) {
            return;
        }
        isInitialized = true;
    }

    private static void readVDW() throws IOException {
        String line;
        String filename = "org/openscience/cdk/config/data/radii-vdw.txt";
        InputStream ins = PeriodicTable.class.getClassLoader().getResourceAsStream(filename);
        BufferedReader reader = new BufferedReader(new InputStreamReader(ins));
        for (int i = 0; i < 6; ++i) {
            reader.readLine();
        }
        while ((line = reader.readLine()) != null) {
            String[] toks = line.split("\\s");
            int atnum = Integer.parseInt(toks[0]);
            double vdw = Double.parseDouble(toks[1]);
            PeriodicTableElement e = elementsByNumber.get(atnum);
            if (e == null) continue;
            String symbol = e.getSymbol();
            if (vdw == 2.0) {
                elements.get(symbol).setVdwRadius((Double)CDKConstants.UNSET);
                continue;
            }
            elements.get(symbol).setVdwRadius(vdw);
        }
    }

    private static void readCovalent() throws IOException {
        String line;
        String filename = "org/openscience/cdk/config/data/radii-covalent.txt";
        InputStream ins = PeriodicTable.class.getClassLoader().getResourceAsStream(filename);
        BufferedReader reader = new BufferedReader(new InputStreamReader(ins));
        for (int i = 0; i < 5; ++i) {
            reader.readLine();
        }
        while ((line = reader.readLine()) != null) {
            String[] toks = line.split("\\s");
            int atnum = Integer.parseInt(toks[0]);
            double vdw = Double.parseDouble(toks[1]);
            PeriodicTableElement e = elementsByNumber.get(atnum);
            if (e == null) continue;
            String symbol = e.getSymbol();
            elements.get(symbol).setCovalentRadius(vdw);
        }
    }

    private static void readPEneg() throws IOException {
        String line;
        String filename = "org/openscience/cdk/config/data/electroneg-pauling.txt";
        InputStream ins = PeriodicTable.class.getClassLoader().getResourceAsStream(filename);
        BufferedReader reader = new BufferedReader(new InputStreamReader(ins));
        for (int i = 0; i < 6; ++i) {
            reader.readLine();
        }
        while ((line = reader.readLine()) != null) {
            String[] toks = line.split("\\s");
            int atnum = Integer.parseInt(toks[0]);
            double eneg = Double.parseDouble(toks[1]);
            PeriodicTableElement e = elementsByNumber.get(atnum);
            if (e == null) continue;
            String symbol = e.getSymbol();
            elements.get(symbol).setPaulingEneg(eneg);
        }
    }

    @TestMethod(value="testTable")
    public static Double getVdwRadius(String symbol) {
        PeriodicTable.initialize();
        PeriodicTableElement element = elements.get(symbol);
        if (element == null) {
            return null;
        }
        return element.getVdwRadius();
    }

    @TestMethod(value="testTable")
    public static Double getCovalentRadius(String symbol) {
        PeriodicTable.initialize();
        PeriodicTableElement element = elements.get(symbol);
        if (element == null) {
            return null;
        }
        return element.getCovalentRadius();
    }

    @TestMethod(value="testTable")
    public static String getCASId(String symbol) {
        PeriodicTable.initialize();
        PeriodicTableElement element = elements.get(symbol);
        if (element == null) {
            return null;
        }
        return element.getCASid();
    }

    @TestMethod(value="testTable")
    public static String getChemicalSeries(String symbol) {
        PeriodicTable.initialize();
        PeriodicTableElement element = elements.get(symbol);
        if (element == null) {
            return null;
        }
        return element.getChemicalSerie();
    }

    @TestMethod(value="testTable")
    public static Integer getGroup(String symbol) {
        PeriodicTable.initialize();
        PeriodicTableElement element = elements.get(symbol);
        if (element == null) {
            return null;
        }
        return element.getGroup();
    }

    @TestMethod(value="testTable")
    public static String getName(String symbol) {
        PeriodicTable.initialize();
        PeriodicTableElement element = elements.get(symbol);
        if (element == null) {
            return null;
        }
        return element.getName();
    }

    @TestMethod(value="testTable")
    public static Integer getPeriod(String symbol) {
        PeriodicTable.initialize();
        PeriodicTableElement element = elements.get(symbol);
        if (element == null) {
            return null;
        }
        return element.getPeriod();
    }

    @TestMethod(value="testTable")
    public static String getPhase(String symbol) {
        PeriodicTable.initialize();
        PeriodicTableElement element = elements.get(symbol);
        if (element == null) {
            return null;
        }
        return element.getPhase();
    }

    @TestMethod(value="testTable")
    public static Integer getAtomicNumber(String symbol) {
        PeriodicTable.initialize();
        PeriodicTableElement element = elements.get(symbol);
        if (element == null) {
            return null;
        }
        return element.getAtomicNumber();
    }

    @TestMethod(value="testTable")
    public static Double getPaulingElectronegativity(String symbol) {
        PeriodicTable.initialize();
        PeriodicTableElement element = elements.get(symbol);
        if (element == null) {
            return null;
        }
        return element.getPaulingEneg();
    }

    @TestMethod(value="testTable")
    public static String getSymbol(int atomicNumber) {
        PeriodicTable.initialize();
        PeriodicTableElement element = elementsByNumber.get(atomicNumber);
        if (element == null) {
            return null;
        }
        return element.getSymbol();
    }

    @TestMethod(value="testTable")
    public static int getElementCount() {
        PeriodicTable.initialize();
        return elements.size();
    }
}

