/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.silent;

import java.io.Serializable;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.silent.Atom;
import org.openscience.cdk.silent.AtomContainer;
import org.openscience.cdk.silent.Bond;

public class Ring
extends AtomContainer
implements Serializable,
IRing {
    private static final long serialVersionUID = 6604894792331865990L;

    public Ring() {
    }

    public Ring(IAtomContainer atomContainer) {
        super(atomContainer);
    }

    public Ring(int ringSize, String elementSymbol) {
        this(ringSize);
        this.atomCount = ringSize;
        this.bondCount = ringSize;
        this.atoms[0] = new Atom(elementSymbol);
        for (int i = 1; i < ringSize; ++i) {
            this.atoms[i] = new Atom(elementSymbol);
            this.bonds[i - 1] = new Bond(this.atoms[i - 1], this.atoms[i], IBond.Order.SINGLE);
        }
        this.bonds[ringSize - 1] = new Bond(this.atoms[ringSize - 1], this.atoms[0], IBond.Order.SINGLE);
    }

    public Ring(int ringSize) {
        super(ringSize, ringSize, 0, 0);
    }

    public int getRingSize() {
        return this.atomCount;
    }

    public IBond getNextBond(IBond bond, IAtom atom) {
        for (int f = 0; f < this.getBondCount(); ++f) {
            IBond tempBond = this.getBond(f);
            if (!tempBond.contains(atom) || bond == tempBond) continue;
            return tempBond;
        }
        return null;
    }

    public int getBondOrderSum() {
        int orderSum = 0;
        for (int i = 0; i < this.getBondCount(); ++i) {
            if (this.getBond(i).getOrder() == IBond.Order.SINGLE) {
                ++orderSum;
                continue;
            }
            if (this.getBond(i).getOrder() == IBond.Order.DOUBLE) {
                orderSum += 2;
                continue;
            }
            if (this.getBond(i).getOrder() == IBond.Order.TRIPLE) {
                orderSum += 3;
                continue;
            }
            if (this.getBond(i).getOrder() != IBond.Order.QUADRUPLE) continue;
            orderSum += 4;
        }
        return orderSum;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Ring(");
        buffer.append(super.toString());
        buffer.append(')');
        return buffer.toString();
    }
}

