/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Locale;
import nu.xom.ASCIIWriter;
import nu.xom.GenericWriter;
import nu.xom.ISOArabicWriter;
import nu.xom.ISOCyrillicWriter;
import nu.xom.ISOGreekWriter;
import nu.xom.ISOHebrewWriter;
import nu.xom.ISOThaiWriter;
import nu.xom.Latin10Writer;
import nu.xom.Latin1Writer;
import nu.xom.Latin2Writer;
import nu.xom.Latin3Writer;
import nu.xom.Latin4Writer;
import nu.xom.Latin5Writer;
import nu.xom.Latin6Writer;
import nu.xom.Latin7Writer;
import nu.xom.Latin8Writer;
import nu.xom.Latin9Writer;
import nu.xom.TextWriter;
import nu.xom.UCSWriter;
import nu.xom.UnicodeWriter;

class TextWriterFactory {
    TextWriterFactory() {
    }

    public static TextWriter getTextWriter(Writer out, String encoding) {
        String encodingUpperCase = encoding.toUpperCase(Locale.ENGLISH);
        if (encodingUpperCase.startsWith("UTF") || encodingUpperCase.startsWith("UNICODE")) {
            return new UnicodeWriter(out, encoding);
        }
        if (encodingUpperCase.startsWith("ISO-10646-UCS") || encodingUpperCase.startsWith("UCS") || encodingUpperCase.equals("GB18030")) {
            return new UCSWriter(out, encoding);
        }
        if (encodingUpperCase.equals("ISO-8859-1")) {
            return new Latin1Writer(out, encoding);
        }
        if (encodingUpperCase.equals("ISO-8859-2")) {
            return new Latin2Writer(out, encodingUpperCase);
        }
        if (encodingUpperCase.equals("ISO-8859-3")) {
            return new Latin3Writer(out, encodingUpperCase);
        }
        if (encodingUpperCase.equals("ISO-8859-4")) {
            return new Latin4Writer(out, encodingUpperCase);
        }
        if (encodingUpperCase.equals("ISO-8859-5")) {
            return new ISOCyrillicWriter(out, encodingUpperCase);
        }
        if (encodingUpperCase.equals("ISO-8859-6")) {
            return new ISOArabicWriter(out, encodingUpperCase);
        }
        if (encodingUpperCase.equals("ISO-8859-7")) {
            return new ISOGreekWriter(out, encodingUpperCase);
        }
        if (encodingUpperCase.equals("ISO-8859-8")) {
            return new ISOHebrewWriter(out, encodingUpperCase);
        }
        if (encodingUpperCase.equals("ISO-8859-9") || encodingUpperCase.equals("EBCDIC-CP-TR") || encodingUpperCase.equals("CP1037")) {
            return new Latin5Writer(out, encodingUpperCase);
        }
        if (encoding.equals("ISO-8859-10")) {
            return new Latin6Writer(out, encoding);
        }
        if (encodingUpperCase.equals("ISO-8859-11") || encodingUpperCase.equals("TIS-620") || encodingUpperCase.equals("TIS620")) {
            return new ISOThaiWriter(out, encodingUpperCase);
        }
        if (encodingUpperCase.equals("ISO-8859-13")) {
            return new Latin7Writer(out, encodingUpperCase);
        }
        if (encoding.equals("ISO-8859-14")) {
            return new Latin8Writer(out, encoding);
        }
        if (encodingUpperCase.equals("ISO-8859-15")) {
            return new Latin9Writer(out, encodingUpperCase);
        }
        if (encoding.equals("ISO-8859-16")) {
            return new Latin10Writer(out, encoding);
        }
        if (encodingUpperCase.endsWith("ASCII")) {
            return new ASCIIWriter(out, encodingUpperCase);
        }
        if (encodingUpperCase.equals("IBM037") || encodingUpperCase.equals("CP037") || encodingUpperCase.equals("EBCDIC-CP-US") || encodingUpperCase.equals("EBCDIC-CP-CA") || encodingUpperCase.equals("EBCDIC-CP-WA") || encodingUpperCase.equals("EBCDIC-CP-NL") || encodingUpperCase.equals("CSIBM037")) {
            return new Latin1Writer(out, encodingUpperCase);
        }
        try {
            return new GenericWriter(out, encoding);
        }
        catch (UnsupportedEncodingException ex) {
            return new ASCIIWriter(out, encoding);
        }
    }
}

