/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.dnd;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.openscience.cdk.tools.LoggingTool;

public class JCPTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = -2702180989701731589L;
    private DataFlavor localFlavor = DataFlavor.getTextPlainUnicodeFlavor();
    private LoggingTool logger = new LoggingTool((Object)this);
    private String handlerFor;

    public JCPTransferHandler(String handlerFor) {
        this.handlerFor = handlerFor;
        this.logger.debug((Object)"Instantiated new transfer handler for:", (Object)handlerFor);
    }

    public boolean importData(JComponent c, Transferable t) {
        this.logger.debug((Object)this.handlerFor, (Object)"Importing data into: ", (Object)c.getClass().getName());
        if (!this.canImport(c, t.getTransferDataFlavors())) {
            this.logger.debug((Object)"Cannot import data...");
            return false;
        }
        return false;
    }

    protected void exportDone(JComponent c, Transferable data, int action) {
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        this.logger.debug((Object)this.handlerFor, (Object)"Offered formats:");
        for (int i = 0; i < flavors.length; ++i) {
            this.logger.debug((Object)"  ", (Object)flavors[i].getMimeType());
        }
        return true;
    }

    protected Transferable createTransferable(JComponent c) {
        this.logger.debug((Object)this.handlerFor, (Object)"Creating transferable...");
        return null;
    }

    public int getSourceActions(JComponent c) {
        this.logger.debug((Object)this.handlerFor, (Object)"Getting source action...");
        return 3;
    }

    public class JCPTransferable
    implements Transferable {
        ArrayList data;

        public JCPTransferable(ArrayList alist) {
            this.data = alist;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.data;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{JCPTransferHandler.this.localFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return JCPTransferHandler.this.localFlavor.equals(flavor);
        }
    }
}

