% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_s3_methods.R
\name{create_s3_method}
\alias{create_s3_method}
\alias{create_s3_print}
\title{Template functions to generate basic S3 methods for new classes}
\usage{
create_s3_method(generic = NULL, object = NULL)

create_s3_print(fun, ...)
}
\arguments{
\item{generic, object}{as described for \code{\link{NextMethod}}}

\item{fun}{Function to transform object before print 
(probably \code{\link{as.character}}, \code{\link{as.numeric}} or similair).}

\item{...}{additional arguments passed to print method}
}
\value{
S3-method.
}
\description{
\code{create_s3_method} creates a method that applies \code{NextMethod} but that also keeps additional 
attributes (such as class).
\code{create_s3_print} creates a print method.
}
\details{
Don't forget to also create for example a data.frame method by

\code{as.data.frame.xxx <- as.data.frame.vector}
}
\examples{
a <- structure(1:10, class = c("b", "numeric"))
a[3] # Normal subsetting makes a loose its attributes
`[.b` <- create_s3_method("[")
print.b <- create_s3_print(as.numeric)
a[3] # attributes preserved even if we can't see them
str(a[3])

}

