% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.CalDates}
\alias{plot.CalDates}
\title{Plot calibrated dates}
\usage{
\method{plot}{CalDates}(x, ind = 1, label = NA, calendar = "BP",
  type = "standard", xlab = NA, ylab = NA, axis4 = TRUE,
  HPD = FALSE, credMass = 0.95, customCalCurve = NA, ...)
}
\arguments{
\item{x}{\code{CalDates} class object containing calibrated radiocarbon dates.}

\item{ind}{Number indicating the index value of the calibrated radiocarbon date to be displayed. Default is 1.}

\item{label}{(optional) Character vector to be shown on the top-right corner of the display window.}

\item{calendar}{Either \code{'BP'} or \code{'BCAD'}. Indicate whether the calibrated date should be displayed in BP or BC/AD. Default is  \code{'BP'}.}

\item{type}{Either \code{'standard'} or \code{'auc'}. If set to \code{'auc'}, displays both the normalised (dashed line) and unnormalised curves. Default is \code{'standard'}.}

\item{xlab}{(optional) Label for the x axis. If unspecified the default setting will be applied ("Year BP" or "Year BC/AD").}

\item{ylab}{(optional) Label for the y axis. If unspecified the default setting will be applied ("Radiocarbon Age").}

\item{axis4}{Logical value indicating whether an axis of probabilities values should be displayed. Default is TRUE.}

\item{HPD}{Logical value indicating whether intervals of higher posterior density should be displayed. Default is FALSE.}

\item{credMass}{A numerical value indicating the size of the higher posterior density interval. Default is 0.95 (i.e. 95\%).}

\item{customCalCurve}{A three column data.frame or matrix that allows you to pass and plot a custom calibration curve if you used one during calibration. You can currently only provide one such custom curve which is used for all dates.}

\item{...}{Additional arguments affecting the plot.}
}
\description{
Plot calibrated radiocarbon dates.
}
\examples{
x <- calibrate(x=c(3402,3490,4042),errors=c(20,20,30))
plot(x) #display the first date
plot(x,2) #displays the second date
plot(x,3, calendar="BCAD", HPD=TRUE) #display in BC/AD with higher posterior density interval
}
\seealso{
\code{\link{calibrate}}
}
