% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chessboard.R
\name{chessboard}
\alias{chessboard}
\title{Chessboard segmentation}
\usage{
chessboard(r, size)
}
\arguments{
\item{r}{\linkS4class{SpatRaster}.}

\item{size}{Numerica vector of length one. Size of the square segments.}
}
\value{
A single layer image of the class \linkS4class{SpatRaster} with
  integer values.
}
\description{
Chessboard segmentation
}
\examples{
\dontrun{
caim <- read_caim()
seg <- chessboard(caim, 100)
plot(caim$Blue)
plot(extract_feature(caim$Blue, seg))
}
}
\seealso{
Other Segmentation Functions: 
\code{\link{mask_hs}()},
\code{\link{mask_sunlit_canopy}()},
\code{\link{polar_qtree}()},
\code{\link{qtree}()},
\code{\link{rings_segmentation}()},
\code{\link{sectors_segmentation}()},
\code{\link{sky_grid_segmentation}()}
}
\concept{Segmentation Functions}
