% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{normalize}
\alias{normalize}
\title{Normalize data}
\usage{
normalize(r, mn = NULL, mx = NULL)
}
\arguments{
\item{r}{\code{\linkS4class{Raster}} or numeric vector.}

\item{mn}{Numeric vector of length one. Minimum expected value. Defaults is
equivalent to the minimum value from \code{r}.}

\item{mx}{Numeric vector of length one. Maximum expected value. Defaults is
equivalent to the maximum value from \code{r}.}
}
\value{
An object from the same class than \code{r} with values from \code{r}
  linearly rescaled to make \code{mn} equal to zero and \code{mx} equal to
  one. Therefore, if \code{mn} and \code{mx} do not match with the actuals
  minimum and maximum from \code{r}, the ourput will not cover the 0-to-1
  range.
}
\description{
Normalize data laying between \code{mn} and \code{mx} in the range \code{0}
to \code{1}. Data greater than \code{mx} get values greater than \code{1} in
a proportional fashion. Conversely, data less than \code{mn} get values less
than \code{0}.
}
\examples{
normalize(read_caim(), 0, 255)
}
\seealso{
\code{\link{gbc}}

Other Tools functions: 
\code{\link{apply_thr}()},
\code{\link{extract_feature}()},
\code{\link{gbc}()},
\code{\link{masking}()},
\code{\link{read_bin}()},
\code{\link{read_caim}()},
\code{\link{regional_thresholding}()},
\code{\link{write_bin}()},
\code{\link{write_caim}()}
}
\concept{Tools functions}
