% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{adjust_dimensions}
\alias{adjust_dimensions}
\title{Adjust Dimensions of Prior Parameters for Stan Usage}
\usage{
adjust_dimensions(same_cov, param_list)
}
\arguments{
\item{same_cov}{A logical indicating whether the same covariance structure is used for all groups.
If \code{TRUE}, the function will return the parameters only once.}

\item{param_list}{A list of parameters, which can be matrices or numeric vectors. Note that this
contains one element for each group, independent of \code{same_cov}.}
}
\value{
The parameters adjusted to the appropriate dimensions for Stan.
}
\description{
This function adjusts the dimensions of prior parameters based on whether
the same covariance structure is used for all groups, and whether the parameters
are lists of matrices or numeric vectors. This is really only necessary to deal with
some peculiarities of how Stan handles arrays and vectors. See \code{\link[=prepare_prior_params]{prepare_prior_params()}}
where this is used.
}
\keyword{internal}
