% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stringdb.R
\name{rba_string_homology_inter}
\alias{rba_string_homology_inter}
\title{Get Similarity Scores Hits of Proteins in Different Species}
\usage{
rba_string_homology_inter(ids, species = NULL, species_b = NULL, ...)
}
\arguments{
\item{ids}{Your protein ID(s). It is strongly recommended to supply
STRING IDs. See \code{\link{rba_string_map_ids}} for more information.}

\item{species}{Numeric: NCBI Taxonomy identifier of your input proteins;
Human Taxonomy ID is 9606. (Recommended, but optional if your input is
less than 100 IDs.)}

\item{species_b}{(optional) Numeric: one or more NCBI Taxonomy identifiers
of species to limit the closets homologous proteins search.}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
A data frame with Your input proteins and it's closest homologous
  proteins among all other (or a defined) STRING species.
}
\description{
Using this function, you can retrieve highest Smith-Waterman bit scores
  among your input proteins and proteins in every other STRING species
  (e.g. the closest homologous protein of your input protein in other
  species).
  Bit Scores serve as similarity scores between protein sequence;
  And, according to STRING documentations, as a proxy for protein homology.
}
\details{
Note that this function will return the highest similarity score hits of
  your given protein(s) and their closets homologous proteins in other
  species. to retrieve similarity scores of different proteins within the
  same species see \code{\link{rba_string_homology_intra}}.
  \cr Similarity matrix is imported -by STRING- from:
  \href{https://cube.univie.ac.at/resources/simap}{Similarity Matrix of
  Proteins (SIMAP)}
}
\section{Corresponding API Resources}{

 "POST https://string-db.org/api/[output-format]/homology_best?
 identifiers=[your_identifiers]"
}

\examples{
\donttest{
rba_string_homology_inter(ids = "p53",
    species = 9606,
    species_b = 7070)
}
\donttest{
rba_string_homology_inter(ids = "ENSP00000269305", species = 9606)
}

}
\references{
\itemize{
  \item Damian Szklarczyk, Annika L Gable, Katerina C Nastou, David Lyon,
  Rebecca Kirsch, Sampo Pyysalo, Nadezhda T Doncheva, Marc Legeay, Tao Fang,
  Peer Bork, Lars J Jensen, Christian von Mering, The STRING database in
  2021: customizable protein–protein networks, and functional
  characterization of user-uploaded gene/measurement sets, Nucleic Acids
  Research, Volume 49, Issue D1, 8 January 2021, Pages D605–D612,
  https://doi.org/10.1093/nar/gkaa1074
  \item \href{https://string-db.org/help/api/}{STRING API Documentation}
  \item
  \href{https://string-db.org/cgi/about?footer_active_subpage=references}{
  Citations note on STRING website}
  }
}
\seealso{
\code{\link{rba_string_map_ids}, \link{rba_string_homology_intra}}

Other "STRING": 
\code{\link{rba_string_annotations}()},
\code{\link{rba_string_enrichment_ppi}()},
\code{\link{rba_string_enrichment}()},
\code{\link{rba_string_homology_intra}()},
\code{\link{rba_string_interaction_partners}()},
\code{\link{rba_string_interactions_network}()},
\code{\link{rba_string_map_ids}()},
\code{\link{rba_string_network_image}()},
\code{\link{rba_string_version}()}
}
\concept{"STRING"}
