% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bi_model.R
\name{write_model}
\alias{write_model}
\alias{write_model.bi_model}
\alias{write_model}
\alias{write_model.libbi}
\title{Writes a bi model to a file.}
\usage{
\method{write_model}{bi_model}(x, filename, update.name = TRUE, ...)

\method{write_model}{libbi}(x, filename, ...)
}
\arguments{
\item{x}{a \code{\link{bi_model}} object, or a \code{\link{libbi}} object conatining a model}

\item{filename}{name of the file to be written}

\item{update.name}{whether to update the model name with the file name}

\item{...}{ignored}
}
\value{
the return value of the \code{\link{writeLines}} call.
}
\description{
Writes a bi model to a file given by \code{filename}. The extension '.bi' will be added if necessary.
}
\examples{
model_file_name <- system.file(package="rbi", "PZ.bi")
PZ <- bi_model(filename = model_file_name)
write_model(PZ, "PZ.bi")
}
\seealso{
\code{\link{bi_model}}
}
