% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhl_getpageocrtext.R
\name{bhl_getpageocrtext}
\alias{bhl_getpageocrtext}
\title{Return the OCR-generated text of a page.}
\usage{
bhl_getpageocrtext(page = NULL, as = "table", key = NULL, ...)
}
\arguments{
\item{page}{page number to get}

\item{as}{(character) Return a list ("list"), json ("json"), xml ("xml"),
or parsed table ("table", default). Note that \code{as="table"} can give
different data format back depending on the function - for example,
sometimes a data.frame and sometimes a character vector.}

\item{key}{Your BHL API key, either enter, or loads from your \code{.Renviron}
as \code{BHL_KEY}
or from \code{.Rprofile} as \code{bhl_key}.}

\item{...}{Curl options passed on to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\description{
Return the OCR-generated text of a page.
}
\examples{
\dontrun{
bhl_getpageocrtext(page=1328690)
bhl_getpageocrtext(1328690, 'json')
}
}
