% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhl_namelist.R
\name{bhl_namelist}
\alias{bhl_namelist}
\title{List the unique names.}
\usage{
bhl_namelist(startrow = NULL, batchsize = NULL, startdate = NULL,
  enddate = NULL, as = "table", key = NULL, ...)
}
\arguments{
\item{startrow}{first name to return (if using as an offset)}

\item{batchsize}{number of names to return (numeric)}

\item{startdate}{(optional) start date of range between which to count names (date)}

\item{enddate}{(optional) end date of range between which to count names (date)}

\item{as}{(character) Return a list ("list"), json ("json"), xml ("xml"), or parsed table
("table", default). Note that \code{as="table"} can give different data format back
depending on the function - for example, sometimes a data.frame and sometimes a
character vector.}

\item{key}{Your BHL API key, either enter, or loads from your \code{.Renviron} as \code{BHL_KEY}
or from \code{.Rprofile} as \code{bhl_key}.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
By using the startrow and batchsize parameters appropriately, you can
   pull the list all at once, or in batches (i.e. 1000 names at a time).
   Names both with and without NameBank identifiers are returned.
}
\examples{
\dontrun{
bhl_namelist(startrow=1, batchsize=99, startdate='10/15/2009', enddate='10/16/2009')
bhl_namelist(startrow=1, batchsize=5, startdate='10/15/2009', enddate='10/31/2009',
   as='json')
}
}

