% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhl_getpagenames.R
\name{bhl_getpagenames}
\alias{bhl_getpagenames}
\title{Return a list of names that appear on a page.}
\usage{
bhl_getpagenames(page = NULL, as = "table", key = NULL, ...)
}
\arguments{
\item{page}{page number to get}

\item{as}{(character) Return a list ("list"), json ("json"), xml ("xml"), or parsed table
("table", default). Note that \code{as="table"} can give different data format back
depending on the function - for example, sometimes a data.frame and sometimes a
character vector.}

\item{key}{Your BHL API key, either enter, or loads from your \code{.Renviron} as \code{BHL_KEY}
or from \code{.Rprofile} as \code{bhl_key}.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
Return a list of names that appear on a page.
}
\examples{
\dontrun{
bhl_getpagenames('1328690')
bhl_getpagenames('1328690', 'json')
bhl_getpagenames('1328690', 'list')
}
}

