% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bhl_getpartbyidentifier.R
\name{bhl_getpartbyidentifier}
\alias{bhl_getpartbyidentifier}
\title{Return a list of the identifiers of all unpublished items.}
\usage{
bhl_getpartbyidentifier(type = NULL, value = NULL, as = "table",
  key = NULL, ...)
}
\arguments{
\item{type}{The type of identifier (doi, oclc, issn, isbn, lccn, ddc, nal, nlm, coden)}

\item{value}{The identifier value}

\item{as}{(character) Return a list ("list"), json ("json"), xml ("xml"), or parsed table
("table", default). Note that \code{as="table"} can give different data format back
depending on the function - for example, sometimes a data.frame and sometimes a
character vector.}

\item{key}{Your BHL API key, either enter, or loads from your \code{.Renviron} as \code{BHL_KEY}
or from \code{.Rprofile} as \code{bhl_key}.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
Return a list of the identifiers of all unpublished items.
}
\examples{
\dontrun{
bhl_getpartbyidentifier('doi', '10.4039/Ent38406-12')
bhl_getpartbyidentifier('doi', '10.4039/Ent38406-12', as='json')
bhl_getpartbyidentifier('doi', '10.4039/Ent38406-12', as='xml')
bhl_getpartbyidentifier('doi', '10.4039/Ent38406-12', as='list')
}
}

