% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgmfile.r
\name{bgmfile}
\alias{bgmfile}
\alias{bgmfile}
\alias{read_bgm}
\title{Read BGM}
\usage{
bgmfile(x, ...)

read_bgm(x, ...)
}
\arguments{
\item{x}{path to a bgm file}

\item{...}{ignored for now}
}
\description{
Read geometry and full topology from BGM files.
}
\details{
BGM is a file format used for the 'Box Geometry Model' in the Atlantis Ecosystem Model. 
This function reads everything from the .bgm file and returns it as linked tables.
}
\examples{
library(bgmfiles)
bfile <- sample(bgmfiles(), 1L)
bgm <- bgmfile(bfile)
library(tibble)
bgm
}
\seealso{
See helper functions to convert the bgm tables to `Spatial` objects, \code{\link{boxSpatial}}, 
\code{\link{faceSpatial}}, \code{\link{nodeSpatial}}, \code{\link{boundarySpatial}}, \code{\link{pointSpatial}}
}
