% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMC.R
\name{thinner}
\alias{thinner}
\title{Thin iterations.}
\usage{
thinner(proportion = 0.1, set = get("info"), write = TRUE)
}
\arguments{
\item{proportion}{Proportion of iterations to remove. Should be between 0 and 1. Default \code{proportion=0.1}.}

\item{set}{Detailed information of the current run, stored within this session's memory as variable \code{info}.}

\item{write}{Whether or not to write the changes to the output file. Defaults to TRUE.}
}
\value{
NA
}
\description{
Randomly thin iterations by a given proportion, for example if autocorrelation is visible within the MCMC series.
}
\details{
From all iterations, a proportion is removed with to-be-removed iterations sampled randomly among all iterations.
}
\examples{
\donttest{
  Bacon(ask=FALSE, coredir=tempfile())
  nrow(info$output)
  thinner(.2)
  nrow(info$output)
}

}
\author{
Maarten Blaauw, J. Andres Christen
}
