% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scraper-futures.R
\name{maturity2date}
\alias{maturity2date}
\title{Get maturity date from maturity code}
\usage{
maturity2date(x, expr = "first day")
}
\arguments{
\item{x}{a character vector with three letters string that represent
maturity of futures contracts.}

\item{expr}{a string which indicates the day to use in maturity date.
See \code{bizdays::getdate} for more details on this argument.}
}
\value{
a Date vector with maturity dates
}
\description{
Get the corresponding maturity date for the three characters string
that represent maturity of futures contracts.
}
\examples{
maturity2date(c("F22", "F23", "G23", "H23", "F45"), "first day")
maturity2date(c("F23", "K35"), "15th day")
}
