% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lines.R
\name{translate_lines}
\alias{translate_lines}
\title{Translate Lines}
\usage{
translate_lines(lines, position = 1)
}
\arguments{
\item{lines}{The line scene.}

\item{position}{Default `c(0,0,0)`. The translation vector.}
}
\value{
Translated line matrix.
}
\description{
Translate Lines
}
\examples{
if(rayvertex:::run_documentation()) {
#Generate a cube out of lines
cube_outline = generate_line(start = c(-1, -1, -1), end = c(-1, -1, 1)) |>
  add_lines(generate_line(start = c(-1, -1, -1), end = c(-1, 1, -1))) |>
  add_lines(generate_line(start = c(-1, -1, -1), end = c(1, -1, -1))) |>
  add_lines(generate_line(start = c(-1, -1, 1), end = c(-1, 1, 1))) |>
  add_lines(generate_line(start = c(-1, -1, 1), end = c(1, -1, 1))) |>
  add_lines(generate_line(start = c(-1, 1, 1), end = c(-1, 1, -1))) |>
  add_lines(generate_line(start = c(-1, 1, 1), end = c(1, 1, 1))) |>
  add_lines(generate_line(start = c(1, 1, -1), end = c(1, -1, -1))) |>
  add_lines(generate_line(start = c(1, 1, -1), end = c(1, 1, 1))) |>
  add_lines(generate_line(start = c(1, -1, -1), end = c(1, -1, 1))) |>
  add_lines(generate_line(start = c(1, -1, 1), end = c(1, 1, 1))) |>
  add_lines(generate_line(start = c(-1, 1, -1), end = c(1, 1, -1))) 
rasterize_lines(cube_outline,fov=40,lookfrom=c(1,2,10),lookat=c(0,0,0))
}
if(rayvertex:::run_documentation()) {
#Scale the cube uniformly
translated_cube = color_lines(translate_lines(cube_outline,c(1,1,1)),"red")
translated_cube2 = color_lines(translate_lines(cube_outline,c(-1,-1,-1)),"green")

cube_outline |>
  add_lines(translated_cube) |>
  add_lines(translated_cube2) |>
  rasterize_lines(fov=40,lookfrom=c(1,2,10),lookat=c(0,0,0))
}
}
