% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ray_path.R
\name{ray_path}
\alias{ray_path}
\title{Calculate the ray paths / great circles}
\usage{
ray_path(x, y)
}
\arguments{
\item{x}{vector with the longitude obtained with \code{ray} or \code{ray_source}}

\item{y}{vector with the latitude obtained with \code{ray} or \code{ray_source}}
}
\value{
sfc_LINESTRING sfc
}
\description{
This function calculates the great circles using the (lat, lon) coordinates
obtained with \code{ray} or \code{ray_source}. It returns a LINESTRING geometry that
is ready for plot.
}
\examples{
{
# Coelho et al. (2015):
input <- system.file("extdata",
                     "uwnd.mon.mean_200hPa_2014JFM.nc",
                      package = "raytracing")
b <- betaks(u = input)
rt <- ray(betam = b$betam,
          u = b$u,
          lat = b$lat,
          K = 3,
          itime = 30,
          x0 = -135,
          y0 = -30,
          dt = 6,
          direction = -1)
rp <- ray_path(x = rt$lon, y = rt$lat)
plot(rp,  axes = TRUE, graticule = TRUE)
}
}
