% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/materials.R
\name{light}
\alias{light}
\title{Light Material}
\usage{
light(
  color = "#ffffff",
  intensity = 10,
  importance_sample = TRUE,
  spotlight_focus = NA,
  spotlight_width = 30,
  spotlight_start_falloff = 15,
  invisible = FALSE,
  image_texture = "",
  image_repeat = 1,
  gradient_color = NA,
  gradient_transpose = FALSE,
  gradient_point_start = NA,
  gradient_point_end = NA,
  gradient_type = "hsv"
)
}
\arguments{
\item{color}{Default `white`. The color of the light Can be either
a hexadecimal code, R color string, or a numeric rgb vector listing three intensities between `0` and `1`.}

\item{intensity}{Default `10`. If a positive value, this will turn this object into a light emitting the value specified
in `color` (ignoring other properties). Higher values will produce a brighter light.}

\item{importance_sample}{Default `TRUE`. Keeping this on for lights improves the convergence of the rendering 
algorithm, in most cases. If the object is particularly important in contributing to the light paths
in the image (e.g. light sources, refracting glass ball with caustics, metal objects concentrating light),
this will help with the convergence of the image.}

\item{spotlight_focus}{Default `NA`, no spotlight. Otherwise, a length-3 numeric vector specifying
the x/y/z coordinates that the spotlight should be focused on. Only works for spheres and rectangles.}

\item{spotlight_width}{Default `30`. Angular width of the spotlight.}

\item{spotlight_start_falloff}{Default `15`. Angle at which the light starts fading in intensity.}

\item{invisible}{Default `FALSE`. If `TRUE`, the light itself will be invisible.}

\item{image_texture}{Default `""`. A 3-layer RGB array or filename to be used as the texture on the surface of the object.}

\item{image_repeat}{Default `1`. Number of times to repeat the image across the surface.
`u` and `v` repeat amount can be set independently if user passes in a length-2 vector.}

\item{gradient_color}{Default `NA`. If not `NA`, creates a secondary color for a linear gradient 
between the this color and color specified in `color`. Direction is determined by `gradient_transpose`.}

\item{gradient_transpose}{Default `FALSE`. If `TRUE`, this will use the `v` coordinate texture instead
of the `u` coordinate texture to map the gradient.}

\item{gradient_point_start}{Default `NA`. If not `NA`, this changes the behavior from mapping texture coordinates to 
mapping to world space coordinates. This should be a length-3 vector specifying the x,y, and z points where the gradient
begins with value `color`.}

\item{gradient_point_end}{Default `NA`. If not `NA`, this changes the behavior from mapping texture coordinates to 
mapping to world space coordinates. This should be a length-3 vector specifying the x,y, and z points where the gradient
begins with value `gradient_color`.}

\item{gradient_type}{Default `hsv`. Colorspace to calculate the gradient. Alternative `rgb`.}
}
\value{
Single row of a tibble describing the light material.
}
\description{
Light Material
}
\examples{
#Generate the cornell box without a light and add a single white sphere to the center
scene = generate_cornell(light=FALSE) \%>\%
  add_object(sphere(x=555/2,y=555/2,z=555/2,radius=555/8,material=light()))
if(run_documentation()) {
render_scene(scene, lookfrom=c(278,278,-800),lookat = c(278,278,0), samples=16,
             aperture=0, fov=40, ambient_light=FALSE, parallel=TRUE)
}

#Remove the light for direct camera rays, but keep the lighting
scene = generate_cornell(light=FALSE) \%>\%
  add_object(sphere(x=555/2,y=555/2,z=555/2,radius=555/8,
             material=light(intensity=15,invisible=TRUE)))
if(run_documentation()) {
render_scene(scene, lookfrom=c(278,278,-800),lookat = c(278,278,0), samples=16,
             aperture=0, fov=40, ambient_light=FALSE, parallel=TRUE)
}

#All gather around the orb
scene = generate_ground(material = diffuse(checkercolor="grey50")) \%>\%
  add_object(sphere(radius=0.5,material=light(intensity=5,color="red"))) \%>\%
  add_object(obj_model(r_obj(simple_r = TRUE), z=-3,x=-1.5,y=-1, angle=c(0,45,0))) \%>\%
  add_object(pig(scale=0.3, x=1.5,z=-2,y=-1.5,angle=c(0,-135,0)))
if(run_documentation()) {
render_scene(scene, samples=16, parallel=TRUE, clamp_value=10)
}
}
