% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csg_construct.R
\name{csg_rounded_cone}
\alias{csg_rounded_cone}
\title{CSG Rounded Cone}
\usage{
csg_rounded_cone(
  start = c(0, 0, 0),
  end = c(0, 1, 0),
  radius = 0.5,
  upper_radius = 0.2
)
}
\arguments{
\item{start}{Default `c(0, 0, 0)`. Start point of the cone, specifing `x`, `y`, `z`.}

\item{end}{Default `c(0, 1, 0)`. End point of the cone, specifing `x`, `y`, `z`.}

\item{radius}{Default `0.5`. Radius of the bottom of the cone.}

\item{upper_radius}{Default `0.2`. Radius from the top of the cone.}
}
\value{
List describing the box in the scene.
}
\description{
CSG Rounded Cone
}
\examples{
if(rayrender:::run_documentation()) {
#Generate a basic rounded cone:
generate_ground(material=diffuse(checkercolor="grey20")) \%>\% 
  add_object(csg_object(csg_rounded_cone(),material=glossy(color="red"))) \%>\% 
  render_scene(clamp_value=10,fov=20)
  }
if(rayrender:::run_documentation()) {
#Change the orientation by specifying a start and end
generate_ground(material=diffuse(color="dodgerblue4",checkercolor="grey10")) \%>\% 
  add_object(csg_object(csg_rounded_cone(start = c(-1,0.5,-2), end = c(1,0.5,-2),
  radius=0.5),material=glossy(checkercolor="red"))) \%>\% 
  render_scene(clamp_value=10,fov=20,
               lookat=c(0,0.5,-2),lookfrom=c(3,3,10))
 }
if(rayrender:::run_documentation()) {
#Show the effect of changing the radius
generate_ground(material=diffuse(color="dodgerblue4",checkercolor="grey10")) \%>\% 
  add_object(csg_object(
    csg_combine(
    csg_rounded_cone(start = c(-1,0.5,-2), end = c(1,0.5,-2), radius=0.5),
    csg_rounded_cone(start = c(-0.5,1.5,-2), end = c(0.5,1.5,-2), radius=0.2,upper_radius = 0.5)),
    material=glossy(checkercolor="red"))) \%>\% 
  render_scene(clamp_value=10,fov=20,
               lookat=c(0,0.5,-2),lookfrom=c(-3,3,10))
}
if(rayrender:::run_documentation()) {         
#Render a glass rounded cone in a Cornell box
generate_cornell() \%>\% 
  add_object(csg_object(
    csg_rounded_cone(start = c(555/2,555/2-100,555/2), end = c(555/2,555/2+100,555/2), radius=100),
    material=dielectric(attenuation=c(1,1,0.3)/100))) \%>\% 
  render_scene(clamp_value=10)
}
}
