% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast_cov.R
\name{fast_cov}
\alias{fast_cov}
\title{Calculate massive covariance matrix in parallel}
\usage{
fast_cov(x, y = NULL, col_x = NULL, col_y = NULL, df = NA)
}
\arguments{
\item{x}{a numeric vector, matrix or data frame; a matrix is highly
recommended to maximize the performance}

\item{y}{NULL (default) or a vector, matrix or data frame with compatible
dimensions to x; the default is equivalent to \code{y = x}}

\item{col_x}{integers indicating the subset indices (columns) of \code{x} to
calculate the covariance, or \code{NULL} to include all the columns; default
is \code{NULL}}

\item{col_y}{integers indicating the subset indices (columns) of \code{y} to
calculate the covariance, or \code{NULL} to include all the columns; default
is \code{NULL}}

\item{df}{a scalar indicating the degrees of freedom; default is
\code{nrow(x)-1}}
}
\value{
A covariance matrix of \code{x} and \code{y}. Note that there is no
\code{NA} handling. Any missing values will lead to \code{NA} in the
resulting covariance matrices.
}
\description{
Speed up covariance calculation for large matrices. The
default behavior is the same as \code{\link{cov}} (\code{'pearson'},
no \code{NA} handling).
}
\examples{

# Set ncores = 2 to comply to CRAN policy. Please don't run this line
RcppParallel::setThreadOptions(numThreads = 2L)

x <- matrix(rnorm(400), nrow = 100)

# Call `cov(x)` to compare
fast_cov(x)

# Calculate covariance of subsets
fast_cov(x, col_x = 1, col_y = 1:2)

if(interactive()){

# Speed comparison, better to use multiple cores (4, 8, or more)
# to show the differences.

RcppParallel::setThreadOptions(numThreads = -1)
x <- matrix(rnorm(100000), nrow = 1000)
microbenchmark::microbenchmark(
  fast_cov = {
    fast_cov(x, col_x = 1:50, col_y = 51:100)
  },
  cov = {
    cov(x[,1:50], x[,51:100])
  },
  unit = 'ms', times = 10
)

}


}
